#include <assert.h>
#include <errno.h>
#include <iostream>
#include <pthread.h>
#include <stdio.h>
#include <A++.h>
#include "testinter.h"

// this is a simple example that can show how the Interpolator API can be used
// it can be used with two different endpoint abstractions: communication
// over files or communication using MetaChaos.
//
// Either ICENDPOINT of FILEENDPOINT has to be turned on in the Makefile

#if (defined(ICENDPOINT) && defined(FILEENDPOINT)) || (!defined(ICENDPOINT) && !defined(FILEENDPOINT))
#error You have to defined either ICENDPOINT or FILEENDPOINT
#endif

#ifdef FILEENDPOINT
#include "FILE_EndPoint.h"
#endif
#ifdef ICENDPOINT
#include "IC_EndPoint.h"
#endif

#ifdef PPLUSPLUS
#include "IC_util.h"
#include "IC_support.h"
Mutex MPIm; // MPI is not reentrant!
#endif

Index I(3,3), J(2,3);
Index K(0,2), L(4,2);
Index M(0,3), N(0,3);
Index O(1,3), P(1,3);
const unsigned NITERATIONS=1000;

void* simu1(void*) {
// this function simulates a parallel simulation code named simu1
  int ic_err;
  std::cout << ">>>> simu1 has started...\n";
#ifdef PPLUSPLUS
  MPIm.lock();
#endif
  doubleArray A(6,6);
  A=45;
#ifdef PPLUSPLUS
  MPIm.unlock();
#endif
#ifdef FILEENDPOINT
  FILE_EndPoint simu1simu2("simu1:simu2");
#endif
#ifdef ICENDPOINT
  IC_EndPoint simu1simu2("simu1:simu2",1,1,IC_EndPoint::IC_COLUMN_MAJOR,IC_EndPoint::IC_COLUMN_MAJOR,ic_err);
  assert(ic_err==IC_EndPoint::IC_OK);
#endif
  // communication steps
  unsigned i;
  for(i=0;i<NITERATIONS;++i) {
#ifdef MYCOPY
    std::cout << "Exporting for the " << i << "th time!\n";
    const doubleArray& t1=A(I,J);
    simu1simu2.exportArray(t1,ic_err);
    assert(ic_err==IC_EndPoint::IC_OK);
    std::cout << "first export is complete\n";
    const doubleArray& t2=A(M,N);
    simu1simu2.importArray(t2,ic_err);
    assert(ic_err==IC_EndPoint::IC_OK);
    std::cout << "first import is complete\n";
    const doubleArray& t3=A(K,L);
    simu1simu2.exportArray(t3,ic_err);
    assert(ic_err==IC_EndPoint::IC_OK);
    std::cout << "second export is complete\n";
#else
    std::cout << "Exporting for the " << i << "th time!\n";
//    simu1simu2.exportArray(A(I,J),ic_err);
//    assert(ic_err==IC_EndPoint::IC_OK);
//    simu1simu2.importArray(A(M,N),ic_err);
//    assert(ic_err==IC_EndPoint::IC_OK);
//    simu1simu2.exportArray(A(K,L),ic_err);
//    assert(ic_err==IC_EndPoint::IC_OK);

    simu1simu2.exportArray(A,ic_err);
    assert(ic_err==IC_EndPoint::IC_OK);
    simu1simu2.importArray(A,ic_err);
    assert(ic_err==IC_EndPoint::IC_OK);
    simu1simu2.exportArray(A,ic_err);
    assert(ic_err==IC_EndPoint::IC_OK);
    simu1simu2.importArray(A,ic_err);
    assert(ic_err==IC_EndPoint::IC_OK);

#endif
  }
  A.display("A");

  return NULL;
}

void* simu2(void*) {
// this function simulates a parallel simulation code named simu2
  int ic_err;
  std::cout << ">>>> simu1 has started...\n";
#ifdef PPLUSPLUS
  MPIm.lock();
#endif
  doubleArray B(6,6);
  B=20;
  B.display("B");
#ifdef PPLUSPLUS
  MPIm.unlock();
#endif
#ifdef FILEENDPOINT
  FILE_EndPoint simu1simu2("simu2:simu1");
#endif
#ifdef ICENDPOINT
  IC_EndPoint simu1simu2("simu2:simu1",1,1,IC_EndPoint::IC_COLUMN_MAJOR,IC_EndPoint::IC_COLUMN_MAJOR,ic_err);
  assert(ic_err==IC_EndPoint::IC_OK);
#endif
  // communication steps
  unsigned i;
  for(i=0;i<NITERATIONS;++i) {
#ifdef MYCOPY
    std::cout << "Importing for the " << i << "th time!\n";
    const doubleArray& t1=B(M,N);
    simu1simu2.importArray(t1,ic_err);
    assert(ic_err==IC_EndPoint::IC_OK);
    std::cout << "first import is complete\n";
    const doubleArray& t2=B(O,P);
    simu1simu2.exportArray(t2,ic_err);
    assert(ic_err==IC_EndPoint::IC_OK);
    std::cout << "first export is complete\n";
    const doubleArray& t3=B(K,L);
    simu1simu2.importArray(t3,ic_err);
    assert(ic_err==IC_EndPoint::IC_OK);
    std::cout << "second import is complete\n";
#else
    std::cout << "Importing for the " << i << "th time!\n";
//    simu1simu2.importArray(B(M,N),ic_err);
//    assert(ic_err==IC_EndPoint::IC_OK);
//    simu1simu2.exportArray(B(O,P),ic_err);
//    assert(ic_err==IC_EndPoint::IC_OK);
//    simu1simu2.importArray(B(K,L),ic_err);
//    assert(ic_err==IC_EndPoint::IC_OK);

    simu1simu2.importArray(B,ic_err);
    assert(ic_err==IC_EndPoint::IC_OK);
    simu1simu2.exportArray(B,ic_err);
    assert(ic_err==IC_EndPoint::IC_OK);
    simu1simu2.importArray(B,ic_err);
    assert(ic_err==IC_EndPoint::IC_OK);
    simu1simu2.exportArray(B,ic_err);
    assert(ic_err==IC_EndPoint::IC_OK);

#endif
  }
  B.display("B");

  return NULL;
}

int main(int argc, char* argv[]) {
#ifdef ICENDPOINT
  if (argc==1) {
    std::cerr << "Can't run both simu2 and simu1 as threads...\n";
    std::cerr << "Try '" << argv[0] << " simu2' or '" << argv[0] << " simu1'!\n";
    return -1;
  }
#endif

  if (argc>1 && 
      (strcmp(argv[1],"simu2")!=0 && strcmp(argv[1],"simu1")!=0)) {
    std::cerr << "Try '" << argv[0] << " simu2' or '" << argv[0] << " simu1'!\n";
    return -1;
  }

#ifdef PPLUSPLUS
  std::cout << ">> P++ is being used...\n";
#else
  std::cout << ">> A++ is being used...\n";
#endif
#ifdef FILEENDPOINT
  std::cout << ">> FileEndPoint is being used...\n";
#endif
#ifdef ICENDPOINT
  std::cout << ">> MetaChaos is being used...\n";
#endif

  int iNumProcs=1;
  Optimization_Manager::Initialize_Virtual_Machine("",iNumProcs,argc,argv);

  pthread_attr_t thattr;
  pthread_t tid1, tid2;
  int ret=pthread_attr_init(&thattr);
  assert(ret==0);
  ret=pthread_attr_setdetachstate(&thattr,PTHREAD_CREATE_JOINABLE);
  assert(ret==0);


  if (argc==1 || strcmp(argv[1],"simu2")==0) {
    ret=pthread_create(&tid1,&thattr,simu2,NULL);
    assert(ret==0);
  }

  if (argc==1 || strcmp(argv[1],"simu1")==0) {
    ret=pthread_create(&tid2,&thattr,simu1,NULL);
    assert(ret==0);
  }

  if (argc==1 || strcmp(argv[1],"simu2")==0) {
    ret=pthread_join(tid1,NULL);
    if(ret!=0) {
      perror("waiting for simu2 to finish:");
      return -1;
    }
  }

  if (argc==1 || strcmp(argv[1],"simu1")==0) {
    ret=pthread_join(tid2,NULL);
    if(ret!=0) {
      perror("waiting for simu1 to finish:");
      return -1;
    }
  }

  Optimization_Manager::Exit_Virtual_Machine();

  return 0;
}
