#include  "parti.h"
#include  "mpi.h"
#include  "pgme.h"
#include  <stdio.h>
#include <malloc.h>

int no_off_proc;
SCHED *lesched;

void ReadAll (char *filen, int **OutLeft, int **OutRight, int *Outmyedges)
{
  int i ;
  int u,junk;
  FILE *fp;
  int extra;
  
  int total_vertices;
  int total_edges;
  
  int *left, *right;
  int iestart;
  int myedges;
  
  fp = fopen( filen, "r");
  
  fscanf( fp, "%d %d",  &total_vertices, &total_edges);
  myedges =  total_edges / NumNodeMyPgme() ;
  extra    =  total_edges % NumNodeMyPgme() ;
  if    ( extra == 0 ) {
    iestart  = MyPosMyPgme() * myedges;
  }
  else if ( MyPosMyPgme() <  extra ) {
    iestart = MyPosMyPgme() * (myedges +1) ;
    myedges = myedges + 1;
  }
  else {
    iestart = extra * (myedges + 1) + (MyPosMyPgme() - extra)*myedges ;
  }
  
  left =(int *)malloc(sizeof(int)*myedges);
  right=(int *)malloc(sizeof(int)*myedges);
  if (left==NULL || right==NULL)
    {
      fprintf(stderr,"Exit: left right allocation pb");
      exit(0);
    }
  
  for (i=0; i<iestart; i++) {
    fscanf(fp,"%d %d %d",&junk, &junk, &junk);
  }
  
  for (i=0; i<myedges; i++) {
    fscanf(fp,"%d %d %d", &(left[i]), &(right[i]), &junk);
  }
  
  for( i=0; i< (total_edges-iestart-myedges);  i++) {
    fscanf(fp,"%d %d %d", &junk, &junk, &junk);
  }
  
  fclose (fp);
  *Outmyedges=myedges;
  *OutLeft =left;
  *OutRight=right;
}

int Compute_CH_int(TTABLE *tabptr, 
		   int myvertices, 
		   int myedges, 
		   int *left,
		   int *right,
		   int *sum_abs,
		   int *x,
		   int *y,
		   int ComputeComm) {
  int i;
  int sum_temp,tmp;
  int sum_tempwrk;
  int n1, n2;
  
  /* --------------------- inspector ----------------------------- */
  
  if (ComputeComm==0)
    {
      int nge1;
      int nsched, ig[2];
      int *ig_ref;
      int *local;
      
      nge1 = 2 * myedges;
      ig_ref=(int *)malloc(sizeof(int)*nge1);
      for(i=0; i<myedges; i++) {
	ig_ref[i] = left[i];
	ig_ref[myedges + i] = right[i];
      }
      
      local=(int *)malloc(sizeof(int)*nge1);
      memset(local,0,nge1*sizeof(int));
      
      localize(tabptr, &lesched, ig_ref, local, nge1, &no_off_proc, myvertices, 1);
      
      for(i=0; i<myedges; i++ ) {
	left[i] = local[i];
	right[i] = local[myedges + i];
      }
      
      free(ig_ref);
      free(local);
    }
  
  else{
    
    /* --------------------- executor ----------------------------- */
    
    for( i=myvertices; i<myvertices+no_off_proc; i++) 
      {
	y[i] = 0.0;
      }
    
    igather(&(x[myvertices]), x, lesched);
    
    for(i=0; i< myedges; i++) {
      n1 = left[i] ;
      n2 = right[i];
      y[n1] = y[n1] + ( x[n1] + x[n2] )/4;
      y[n2] = y[n2] + ( x[n1] - x[n2] )/4;
    }
    
    iscatter_add( &(y[myvertices]), y,  lesched );
    
    sum_temp = 0.0;
    
    for( i=0; i< myvertices ; i++ ) {
      tmp  = ( y[i] > 0 ) ? y[i] : (- y[i]);
      sum_temp = sum_temp + tmp;
    }
    
    exit(0);
    
    for(i=myvertices; i< myvertices+no_off_proc; i++ ) {
      x[i]  =  0.0;
    }
    
    *sum_abs = sum_temp;
  }
}

int Compute_CH_double(TTABLE *tabptr,
		      int myvertices,
		      int myedges,
		      int *left,
		      int *right,
		      double *sum_abs,
		      double *x, 
		      double *y,
		      int ComputeComm) {
  int i;
  double sum_temp,tmp;
  double sum_tempwrk;
  int n1, n2;
  
  /* --------------------- inspector ----------------------------- */
  
  if (ComputeComm==0)
    {
      int nge1;
      int nsched, ig[2];
      int *ig_ref;
      int *local;
      
      nge1 = 2 * myedges;
      ig_ref=(int *)malloc(sizeof(int)*nge1);
      for(i=0; i<myedges; i++) {
	ig_ref[i] = left[i];
	ig_ref[myedges + i] = right[i];
      }
      
      local=(int *)malloc(sizeof(int)*nge1);
      memset(local,0,nge1*sizeof(int));
      localize(tabptr, &lesched, ig_ref, local, nge1, &no_off_proc, myvertices, 1);
      
      for(i=0; i<myedges; i++ ) {
	left[i] = local[i];
	right[i] = local[myedges + i];
      }
      
      free(ig_ref);
      free(local);
    }

  else
    {    
      /* --------------------- executor ----------------------------- */
      
      for( i=myvertices; i<myvertices+no_off_proc; i++) 
	{
	  y[i] = 0.0;
	}
      
      dgather(&(x[myvertices]), x, lesched);
      
      for(i=0; i< myedges; i++) {
	n1 = left[i] ;
	n2 = right[i];
	y[n1] = y[n1] + ( x[n1] + x[n2] )/4;
	y[n2] = y[n2] + ( x[n1] - x[n2] )/4;
      }
      
      dscatter_add( &(y[myvertices]), y,  lesched );
      
      sum_temp = 0.0;
      
      for( i=0; i< myvertices ; i++ ) {
	tmp  = ( y[i] > 0 ) ? y[i] : (- y[i]);
	sum_temp = sum_temp + tmp;
      }
      
      exit(0);
      
      for(i=myvertices; i< myvertices+no_off_proc; i++ ) {
	x[i]  =  0.0;
      }
      
      *sum_abs = sum_temp;
    }
}

void *CH_RemappingSched(TTABLE *CH_ttable_bp,
			int *CH_Index,
			int *ch_local,
			int CH_IndexSize,
			int *ch_no_off_proc,
			int CH_IndexSize_bp) {
  SCHED *schedBP2CH;
  
  localize(CH_ttable_bp, &schedBP2CH, CH_Index, ch_local, CH_IndexSize, 
	   ch_no_off_proc, CH_IndexSize_bp, 1);
  return((void *)schedBP2CH);
}

#define TYPE int
#define TYPEscatter iscatter
#define TYPEgather igather

void remap_int(
	   sched,
	   schedArray,
	   schedArraySize,

	   temporary,
	   localPos ,
	   dimLocalPos,
	   
	   receiving_array,
	   sending_array
	   )
SCHED *sched;
int   *schedArray;
int    schedArraySize;
TYPE  *temporary;
int   *localPos;
int    dimLocalPos;

TYPE  *receiving_array;
TYPE  *sending_array;
{int i;

 for (i=0;i<dimLocalPos;i++)
   {
     temporary[i]=sending_array[localPos[i]];
   }
 
 TYPEgather(&(temporary[dimLocalPos]), temporary, sched);
 
 for (i=0;i<schedArraySize;i++)
   {
     receiving_array[i]=temporary[schedArray[i]];
   }
 
}

/* ----------------------------------------------------------------------------------*/

void remap_int_back(
		    sched,
		    schedArray,
		    schedArraySize,
		    
		    temporary,
		    localPos ,
		    dimLocalPos,
		    
		    receiving_array,
		    sending_array
		    )
     SCHED *sched;
     int   *schedArray;
     int   schedArraySize;
     TYPE  *temporary;
     int   *localPos;
     int    dimLocalPos;
     
     TYPE  *receiving_array;
     TYPE  *sending_array;
{int i;
 
 for (i=0;i<dimLocalPos;i++)
   {
     temporary[schedArray[i]]=receiving_array[i];
   }
 
 
 TYPEscatter(&(temporary[dimLocalPos]), temporary, sched);
 
 for (i=0;i<dimLocalPos;i++)
   {
     sending_array[localPos[i]]=temporary[i];
   }
}

/* ----------------------------------------------------------------------------------*/


void remap_double(
		  sched,
		  schedArray,
		  schedArraySize,
		  
		  temporary,
		  localPos ,
		  dimLocalPos,

		  receiving_array,
		  sending_array
		  )
SCHED *sched;
int   *schedArray;
int    schedArraySize;
double  *temporary;
int   *localPos;
int    dimLocalPos;

double  *receiving_array;
double  *sending_array;
{int i;


 for (i=0;i<dimLocalPos;i++)
   {
     temporary[i]=sending_array[localPos[i]];
   }
 
 dgather(&(temporary[dimLocalPos]), temporary, sched);
 
 for (i=0;i<schedArraySize;i++)
   {
     receiving_array[i]=temporary[schedArray[i]];
   }
 
}

/* ----------------------------------------------------------------------------------*/

void remap_double_back(
		    sched,
		    schedArray,
		    schedArraySize,

		    temporary,
		    localPos ,
		    dimLocalPos,
		    
		    receiving_array,
		    sending_array
		    )
     SCHED *sched;
     int   *schedArray;
     int   schedArraySize;
     double  *temporary;
     int   *localPos;
     int    dimLocalPos;
     
     double  *receiving_array;
     double  *sending_array;
{
  int i;

 printf("\n Db: dimLocalPos=%i schedArraySize=%i \n",dimLocalPos,schedArraySize);
  
 for (i=0;i<dimLocalPos;i++)
   {
     temporary[schedArray[i]]=receiving_array[i];
   }
 
 
 dscatter(&(temporary[dimLocalPos]), temporary, sched);
 
 for (i=0;i<dimLocalPos;i++)
   {
     sending_array[localPos[i]]=temporary[i];
   }
}

void set_CH_indices(int NbTotalElem, 
		    int *local_index_array, 
		    int *size_local_index_array,
		    pgme_s *pgme) 
{
  /* I distribute the chaos array in a cyclic fashion */
  int i, numnode, tmp, incr;
  
  numnode = NumNodePgme(pgme);
  printf("numnode=%d\n", numnode);
  tmp = NbTotalElem/numnode; 

  for (i = 0, incr = 0; i < tmp; i++, incr++) {
    local_index_array[i] = i*numnode + MyPosPgme(pgme) /*+ 1*/;
  }
  *size_local_index_array = NbTotalElem/numnode;
  printf("mypos=%d\n", MyPosPgme(pgme));
  if (MyPosPgme(pgme) == 0) {
    for (i = (NbTotalElem/numnode)*numnode; i < NbTotalElem; i++, incr++) {
      local_index_array[incr] = i/*+1*/;
    }
    *size_local_index_array = incr;
  }
}

void set_CH_indices1(int NbTotalElem, 
		     int *local_index_array, 
		     int *size_local_index_array,
		     pgme_s *pgme) 
{
  /* I distribute the chaos array in a cyclic fashion */
  int i, numnode, tmp, incr;
  
  numnode = NumNodePgme(pgme);
  tmp = NbTotalElem/numnode; 
  
  for (i = 0, incr = 0; i < tmp; i++, incr++) {
    local_index_array[i] = MyPosPgme(pgme)*tmp+1+i;
  }
  *size_local_index_array = NbTotalElem/numnode;
  if (MyPosPgme(pgme) == 0) {
    for (i = (NbTotalElem/numnode)*numnode; i < NbTotalElem; i++, incr++)
      local_index_array[incr] = i+1;
    *size_local_index_array = incr;
  }
}
