#include "intercomm.h"
#include <stdio.h>

int create();
int partition1D();
int section1D();
int partition2D();
int section2D();
int partition3D();
int section3D();

#define TESTS 7
int(*tests[TESTS])() = {create, 
			partition1D, section1D, 
			partition2D, section2D, 
			partition3D, section3D};

int create() {
  IC_Tree* root;
  IC_Desc* desc;
  int ndims = 1;
  int size[1] = {10};
  int tasks[1] = {0};
  int count = 1;

  if (!(root = IC_Create_bdecomp_tree()))
    return 0;
  if (!(desc = IC_Verify_bdecomp_tree(root, ndims, size, tasks, count))) {
    IC_Print_error("create");
    return 0;
  } else {
    print_irr(root);
  }
  IC_Free_desc(desc);

  return 1;
}

int partition1D() {
  IC_Tree* root;
  IC_Desc* desc;
  int indices[2] = {5, 10};
  int size[1] = {10};
  int tasks[2] = {0, 1};
  int block[1];

  if (!(root = IC_Create_bdecomp_tree()))
    return 0;
  IC_Partition(root, 0, block, 2, indices);
  if (!(desc = IC_Verify_bdecomp_tree(root, 1, size, tasks, 2))) {
    IC_Print_error("partition1D");
    return 0;
  } else {
    print_irr(root);
  }
  IC_Free_desc(desc);

  return 1;
}

int partition2D() {
  IC_Tree* root;
  IC_Desc* desc;
  int indices[2] = {5, 10};
  int size[2] = {10, 10};
  int tasks[4] = {0, 1, 2, 3};
  int block[2];
  int i;

  if (!(root = IC_Create_bdecomp_tree()))
    return 0;
  IC_Partition(root, 0, block, 2, indices);
  block[0] = 0;
  IC_Partition(root, 1, block, 2, indices);
  block[1] = 0;
  IC_Partition(root, 1, block, 2, indices);
  if (!(desc = IC_Verify_bdecomp_tree(root, 2, size, tasks, 4))) {
    IC_Print_error("partition2D");
    return 0;
  } else {
    print_irr(root);
  }
  IC_Free_desc(desc);

  return 1;
}

int partition3D() {
  IC_Tree* root;
  IC_Desc* desc;
  int indices[2] = {5, 10};
  int size[3] = {10, 10, 10};
  int tasks[8] = {0, 1, 2, 3, 4, 5, 6, 7};
  int block[3];
  int i;

  if (!(root = IC_Create_bdecomp_tree()))
    return 0;
  IC_Partition(root, 0, block, 2, indices);
  block[0] = 0;
  IC_Partition(root, 1, block, 2, indices);
  block[1] = 0;
  IC_Partition(root, 2, block, 2, indices);
  block[1] = 1;
  IC_Partition(root, 2, block, 2, indices);
  block[0] = 1;
  IC_Partition(root, 1, block, 2, indices);
  block[1] = 0;
  IC_Partition(root, 2, block, 2, indices);
  block[1] = 1;
  IC_Partition(root, 2, block, 2, indices);
  if (!(desc = IC_Verify_bdecomp_tree(root, 3, size, tasks, 8))) {
    IC_Print_error("partition3D");
    return 0;
  } else {
    print_irr(root);
  }
  IC_Free_desc(desc);

  return 1;
}

int section1D() {
  IC_Tree* root;
  IC_Desc* desc;
  int indices[2] = {5, 10};
  int size[1] = {10};
  int tasks[2] = {0, 1};

  if (!(root = IC_Create_bdecomp_tree()))
    return 0;
  IC_Section(root, 0, 2, indices);
  if (!(desc = IC_Verify_bdecomp_tree(root, 1, size, tasks, 2))) {
    IC_Print_error("section1D");
    return 0;
  } else {
    print_irr(root);
  }
  IC_Free_desc(desc);
  
  return 1;
}

int section2D() {
  IC_Tree* root;
  IC_Desc* desc;
  int indices[2] = {5, 10};
  int size[2] = {10, 10};
  int tasks[4] = {0, 1, 2, 3};

  if (!(root = IC_Create_bdecomp_tree()))
    return 0;
  IC_Section(root, 0, 2, indices);
  IC_Section(root, 1, 2, indices);
  if (!(desc = IC_Verify_bdecomp_tree(root, 2, size, tasks, 4))) {
    IC_Print_error("section2D");
    return 0;
  } else {
    print_irr(root);
  }
  IC_Free_desc(desc);
  
  return 1;
}

int section3D() {
  IC_Tree* root;
  IC_Desc* desc;
  int indices[2] = {5, 10};
  int size[3] = {10, 10, 10};
  int tasks[8] = {0, 1, 2, 3, 4, 5, 6, 7};

  if (!(root = IC_Create_bdecomp_tree()))
    return 0;
  IC_Section(root, 0, 2, indices);
  IC_Section(root, 1, 2, indices);
  IC_Section(root, 2, 2, indices);
  if (!(desc = IC_Verify_bdecomp_tree(root, 3, size, tasks, 8))) {
    IC_Print_error("section2D");
    return 0;
  } else {
    print_irr(root);
  }
  IC_Free_desc(desc);
  
  return 1;
}

int main(int argc, char* argv[]) {
  int i;

  for (i = 0; i < TESTS; ++i) {
    printf("Running test %d...", i);
    if (tests[i]())
      printf("ok\n");
    else
      printf("failed\n");
  }

  return 1;
}
