#!/usr/local/bin/bash
#
# set -x
#############################################################################
MEDIANET=~/media-net

# do_startup net_type
function do_startup {
  echo starting medianet for configuration $1
  if [ "$1" = "Diamond" ]; then 
  	ssh -n nodeA.diamond.medianet.emulab.net ~/media-net/scripts/startGS
  	$MEDIANET/scripts/ls.sh start $2
  fi
  if [ "$1" = "Line" ]; then
        ssh -n nodeA.diamond.medianet.emulab.net ~/media-net/scripts/startGSline
        $MEDIANET/scripts/lsline.sh start $2 
  fi
}

# do_shutdown net_type
function do_shutdown {
 echo stopping medianet for configuration $1
  if [ "$1" = "Diamond" ]; then
     ssh -n nodeA.diamond.medianet.emulab.net ~/media-net/scripts/stopGS
     $MEDIANET/scripts/ls.sh stop
  fi
  if [ "$1" = "Line" ]; then
     ssh -n nodeA.diamond.medianet.emulab.net ~/media-net/scripts/stopGS
     $MEDIANET/lsline.sh stop
  fi
}

MM_TMP=/tmp/mmconf$$

# do_config user configfile
#   reconfigures the medianet network for the given user
function do_config {
  echo configuring medianet for user $1 using file $2
  host="nodea.diamond.medianet.emulab.net"
  cp $2 $MM_TMP
  cd $MEDIANET/mmsched
  ./mn_config $1 $MM_TMP $host
  \rm $MM_TMP
  cd -
}

# do_init user configfile
#  initializes the medianet network for the given user
function do_init {
  echo initializing medianet for user $1 using file $2
  host="nodea.diamond.medianet.emulab.net"
  cp $2 $MM_TMP
  cd $MEDIANET/mmsched
  ./mn_config $1 $MM_TMP $host x
  \rm $MM_TMP
  cd -
}

# do_server_config port configfile
#   configures the medianet server with the given configuration
SRV_TMP=/tmp/srvconf$$
function do_server_config {
  echo configuring medianet server on port $1 using file $2 at host $3
  cp $2 $SRV_TMP
  $MEDIANET/mmsched/sh_config $1 $SRV_TMP $3
  \rm $SRV_TMP
  cd -
}

#   starts the video
function startvideo {
  echo starting video
  $MEDIANET/scripts/video.sh start $1 $2
}

#   starts the video trace app
function startvideotrace {
  echo starting video trace
  $MEDIANET/scripts/video.sh starttrace $1 $2
}

#  stops the video
function stopvideo {
  echo stopping video
  $MEDIANET/scripts/video.sh stop $1 $2
}

#  stops the video sender
function stopvideosend {
  echo stopping video
  $MEDIANET/scripts/video.sh stopsend $1 $2
}

#  stops the video receiver
function stopvideotrace {
  echo stopping video
  $MEDIANET/scripts/video.sh stoptrace $1 $2
}

# input is in KB/s; will convert to Kb/s for delay_config
function config_bw {
   BS=`echo $2 \* 8 | bc`
   echo changing BW to $BS Kbits per sec
   delay_config -m -b $BS MediaNet Diamond $1 < /dev/null
}
#############################################################################

netconfig=unknown
topology="Diamond"
while true
do
  read tm comm rest
  [[ $? != 0 ]] && break
  if [ -z "$last_tm" ]; then
    last_tm=tm;
  fi

  # wait until the appropriate time
  delta=$((tm - last_tm))
  if [ $delta != 0 ]; then 
    echo will sleep $delta secs
    sleep $delta
  fi
  last_tm=$tm

  # do the command
  if [ "$comm" = "STARTUP" ]; then
    topology=`echo $rest | awk '{ print $1 }'`
    queuesize=`echo $rest | awk '{ print $2 }'`
    #topology=$rest
    do_startup $topology $queuesize
    netconfig=$rest

  elif [ "$comm" = "START" ]; then
    inport1=`echo $rest | awk '{ print $1 }'`
    outport1=`echo $rest | awk '{ print $2 }'`
    startvideo $inport1 $outport1 

  elif [ "$comm" = "STARTTRACE" ]; then
    inport1=`echo $rest | awk '{ print $1 }'`
    outport1=`echo $rest | awk '{ print $2 }'`
    startvideotrace $inport1 $outport1 

  elif [ "$comm" = "STOP" ]; then
    inport2=`echo $rest | awk '{ print $1 }'`
    outport2=`echo $rest | awk '{ print $2 }'`
    stopvideo $inport2 $outport2 

  elif [ "$comm" = "STOPSEND" ]; then
    inport2=`echo $rest | awk '{ print $1 }'`
    outport2=`echo $rest | awk '{ print $2 }'`
    stopvideosend $inport2 $outport2 

  elif [ "$comm" = "STOPTRACE" ]; then
    inport2=`echo $rest | awk '{ print $1 }'`
    outport2=`echo $rest | awk '{ print $2 }'`
    stopvideotrace $inport2 $outport2 

  elif [ "$comm" = "CONFIG" ]; then
    user=`echo $rest | awk '{ print $1 }'`
    file=`echo $rest | awk '{ print $2 }'`
    do_config $user $file

  elif [ "$comm" = "INIT" ]; then
    user=`echo $rest | awk '{ print $1 }'`
    file=`echo $rest | awk '{ print $2 }'`
    do_init $user $file

  elif [ "$comm" = "SERVCONFIG" ]; then
    port=`echo $rest | awk '{ print $1 }'`
    file=`echo $rest | awk '{ print $2 }'`
    host1=`echo $rest | awk '{ print $3 }'`
    do_server_config $port $file $host1

  elif [ "$comm" = "BW" ]; then
    link=`echo $rest | awk '{ print $1 }'`
    bw=`echo $rest | awk '{ print $2 }'`
    config_bw $link $bw $topology

 elif [ "$comm" = "SHUTDOWN" ]; then
    do_shutdown $rest
    netconfig=unknown

 else
    echo "Unknown command $comm !!"
 fi
done
