#!/bin/sh
#
# starts/stops the bowtie configuration

MEDIANET=~/media-net

if [ $# != 2 ]; then
  queuesize=10
else
  queuesize=$2
fi

port=7771
for node in pc1 pc2 pc3 pc4 pc5 pc6 pc7 pc8
do  
  if [ "$1" = "start" ]; then
    ssh -n $node.bowtie.medianet $MEDIANET/scripts/startLS $port $queuesize
  else
    ssh -n $node.bowtie.medianet $MEDIANET/scripts/stopLS $port
  fi
  port=`echo $port + 1 | bc`
done
