#!/usr/bin/perl

if ($#ARGV != 1) {
    die("usage: $0 sender-output receiver-output\n");
}

open(SEND, $ARGV[0]) or die "Can't open file $ARGV[0]: $!\n";
open(RECV, $ARGV[1]) or die "Can't open file $ARGV[1]: $!\n";

$XSZ="";
$YSZ="";
# $XSZ="size 3.5";
# $YSZ="size 1.5";

# graph preamble

print "newgraph\n";
print "clip\n";
print "xaxis $XSZ label : time (s)\n";
print "yaxis $YSZ min 0 max 200 label : delta (us)\n";

# plot for each line of deltas

$i = -1;
while ($sendline = <SEND>) {
    $recvline = <RECV> or die "Receiver file ended prematurely, $i\n";
    ($j1,$j2,$j3,$j4,$j5,$recvdelta) = split(" ",$recvline);
    ($j1,$sendbuf,$sendtime,$j4,$senddelta) = split(" ",$sendline);
    # skip the first line
    if ($i >= 0) {
	$Delta[$i][0] = $recvdelta;
	$Delta[$i][1] = $senddelta;
	$Time[$i] = $sendtime;
    }
    $i++;
}
close(SEND);
close(RECV);

# print "\nnewcurve\n";
# print "  label : receiver\n";
# print "  linetype solid\n";
# print "  marktype none\n";
# print "  pts ";

# for ($j = 0; $j < $i; $j++) {
#     print "$Time[$j] $Delta[$j][0] ";
# }
# print "\n";

# print "\nnewcurve\n";
# print "  label : sender\n";
# print "  linetype dashed\n";
# print "  marktype none\n";
# print "  pts ";

# for ($j = 0; $j < $i; $j++) {
#     print "$Time[$j] $Delta[$j][1] ";
# }
# print "\n";

print "\nnewcurve\n";
print "  label : delta\n";
print "  linetype dotted\n";
print "  marktype none\n";
print "  pts ";

for ($j = 0; $j < $i; $j++) {
    $x = abs($Delta[$j][1] - $Delta[$j][0]);
    print "$Time[$j] $x ";
}
print "\n";


    
