#!/usr/local/bin/bash
#
# set -x
#############################################################################
MEDIANET=~/media-net

# get_gs_node [gs-node]
function get_gs_node {
  if [ -z "$1" ]; then
    echo pc3.bowtie.medianet.emulab.net 
  else
    echo $1
  fi
}

# do_startup net_type queuesize [gs-node]
function do_startup {
  gsnode=`get_gs_node $3`

  echo starting medianet for configuration $1 qSize $2 GS on node $gsnode

  if [ "$1" = "Diamond" ]; then 
  	ssh -n $gsnode $MEDIANET/scripts/startGS Diamond
  	$MEDIANET/scripts/bowtie.sh start $2
  elif [ "$1" = "Line" ]; then
        ssh -n $gsnode $MEDIANET/scripts/startGS Line
        $MEDIANET/scripts/bowtie.sh start $2 
  elif [ "$1" = "Bowtie" ]; then
        ssh -n $gsnode $MEDIANET/scripts/startGS Bowtie
        $MEDIANET/scripts/bowtie.sh start $2 
  fi
}

# do_shutdown net_type [gs-node]
function do_shutdown {
  gsnode=`get_gs_node $2`

  echo stopping medianet for configuration $1 with GS on node $gsnode

  ssh -n $gsnode $MEDIANET/scripts/stopGS
  $MEDIANET/scripts/bowtie.sh stop
}

MM_TMP=/tmp/mmconf$$

# do_config user configfile [gs-node]
#   reconfigures the medianet network for the given user
function do_config {
  gsnode=`get_gs_node $3`

  echo configuring medianet for user $1 using file $2 GS on node $gsnode

  cp $2 $MM_TMP
  cd $MEDIANET/src/mmsched
  ./mn_config $1 $MM_TMP $gsnode
  \rm $MM_TMP
  cd -
}

# do_init user configfile [gs-node]
#  initializes the medianet network for the given user
function do_init {
  gsnode=`get_gs_node $3`

  echo initializing medianet for user $1 using file $2 GS on node $gsnode

  cp $2 $MM_TMP
  cd $MEDIANET/src/mmsched
  ./mn_config $1 $MM_TMP $gsnode x
  \rm $MM_TMP
  cd -
}

# do_server_config port configfile host
#   configures the medianet server with the given configuration
SRV_TMP=/tmp/srvconf$$
function do_server_config {
  echo configuring medianet server on port $1 using file $2 at host $3
  cp $2 $SRV_TMP
  $MEDIANET/src/mmsched/sh_config $1 $SRV_TMP $3
  \rm $SRV_TMP
  cd -
}

# startvideosource host port
#   starts the video source
function startvideosource {
  echo starting video source on node $1 port $2
  ssh -n $1 $MEDIANET/scripts/startsender $2
}

# stopvideosource host port
#  stops the video source
function stopvideosource {
  echo stopping video source on node $1 port $2
  ssh -n $1 $MEDIANET/scripts/stopsender $2
}

# startvideotrace host port
#  starts the video receiver
function startvideotrace {
  echo starting video receiver on node $1 port $2
  ssh -n $1 $MEDIANET/scripts/starttrace $2
}

# stopvideotrace host port
#  stops the video receiver
function stopvideotrace {
  echo stopping video receiver on node $1 port $2
  ssh -n $1 $MEDIANET/scripts/stoptrace $2
}

# config_bw link B/W experiment-id
#   input is in KB/s; will convert to Kb/s for delay_config
function config_bw {
   BS=`echo $2 \* 8 | bc`
   echo changing BW to $BS Kbits per sec for link $l1 topology $3
   delay_config -m -b $BS MediaNet bowtie $1 < /dev/null
}
#############################################################################

topology="Diamond"
while true
do
  read tm comm rest
  [[ $? != 0 ]] && break
  if [ -z "$last_tm" ]; then
    last_tm=tm;
  fi

  # wait until the appropriate time
  delta=$((tm - last_tm))
  if [ $delta != 0 ]; then 
    echo will sleep $delta secs
    sleep $delta
  fi
  last_tm=$tm

  # do the command
  if [ "$comm" = "STARTUP" ]; then
    topology=`echo $rest | awk '{ print $1 }'`
    queuesize=`echo $rest | awk '{ print $2 }'`
    gsnode=`echo $rest | awk '{ print $3 }'`
    do_startup $topology $queuesize $gsnode

  elif [ "$comm" = "START" ]; then
    echo START no longer supported

  elif [ "$comm" = "STOP" ]; then
    echo STOP no longer supported

  elif [ "$comm" = "STARTSEND" ]; then
    host=`echo $rest | awk '{ print $1 }'`
    port=`echo $rest | awk '{ print $2 }'`
    startvideosource $host $port

  elif [ "$comm" = "STARTTRACE" ]; then
    host=`echo $rest | awk '{ print $1 }'`
    port=`echo $rest | awk '{ print $2 }'`
    startvideotrace $host $port

  elif [ "$comm" = "STOPSEND" ]; then
    host=`echo $rest | awk '{ print $1 }'`
    port=`echo $rest | awk '{ print $2 }'`
    stopvideosource $host $port

  elif [ "$comm" = "STOPTRACE" ]; then
    host=`echo $rest | awk '{ print $1 }'`
    port=`echo $rest | awk '{ print $2 }'`
    stopvideotrace $host $port

  elif [ "$comm" = "CONFIG" ]; then
    user=`echo $rest | awk '{ print $1 }'`
    file=`echo $rest | awk '{ print $2 }'`
    gsnode=`echo $rest | awk '{ print $3 }'`
    do_config $user $file $gsnode

  elif [ "$comm" = "INIT" ]; then
    user=`echo $rest | awk '{ print $1 }'`
    file=`echo $rest | awk '{ print $2 }'`
    gsnode=`echo $rest | awk '{ print $3 }'`
    do_init $user $file $gsnode

  elif [ "$comm" = "SERVCONFIG" ]; then
    port=`echo $rest | awk '{ print $1 }'`
    file=`echo $rest | awk '{ print $2 }'`
    host1=`echo $rest | awk '{ print $3 }'`
    do_server_config $port $file $host1

  elif [ "$comm" = "BW" ]; then
    link=`echo $rest | awk '{ print $1 }'`
    bw=`echo $rest | awk '{ print $2 }'`
    config_bw $link $bw $topology

  elif [ "$comm" = "EXP" ]; then
    echo setting topology to $rest
    topology=$rest

  elif [ "$comm" = "SHUTDOWN" ]; then
    do_shutdown $rest

 else
    echo "Unknown command $comm !!"
 fi
done
