#!/usr/bin/perl

# gather all the data

$do_line = 1;

line: while (<>) {
    @Fld = split " ";
    if (/^#.*/) { # comment; skip
        next line;
    }
    elsif ($Fld[1] eq "BW") {
	$bw{$Fld[2]}{$Fld[0]} = $Fld[3];
    }
    $end_time = $Fld[0];
}

# print the results

@linetypes = ("dashed", "solid", "dotted", "longdash");
$linetype = 0;

foreach $link ( sort keys %bw ) {
    print "newcurve\n";
    print "  label : $link b/w\n";
    if ($do_line) {
	print "  linetype $linetypes[$linetype]\n";
	$linetype++;
	print "  marktype none\n";
	$got_one = 0;
    }
    print "  pts ";
    foreach $tm ( sort { $a <=> $b } keys %{ $bw{$link} } ) {
	$v = $bw{$link}{$tm};
	if ($do_line) {
	    if ($got_one) {
		print "$tm $lastv ";
		$lastv = $v;
	    }
	    else {
		$got_one = 1;
		$lastv = $v;
	    }
	}
	print "$tm $v ";
    }
    print "$end_time $v\n";
}

