#include <stdio.h>
#include <sys/time.h>

/* for comparing timevals; if second timeval is NULL, first is < */
int timevalCmp(struct timeval *tv1, struct timeval *tv2) 
{
  if (tv2 == NULL) return -1; /* special case */

  if (tv1->tv_sec > tv2->tv_sec) return 1;
  else if (tv1->tv_sec == tv2->tv_sec)
    if (tv1->tv_usec > tv2->tv_usec) return 1;
    else if (tv1->tv_usec == tv2->tv_usec) return 0;
    else return -1;
  else return -1;
}

/* [tv1] - [tv2] = [res] */
void subTimeval(struct timeval *tv1, struct timeval *tv2, 
		struct timeval *res)
{
  if (tv1 == NULL) { /* special case */
    res->tv_sec = 0;
    res->tv_usec = 0;
  }
  else {
    res->tv_usec = tv1->tv_usec - tv2->tv_usec;
    res->tv_sec = tv1->tv_sec - tv2->tv_sec;
    if (res->tv_usec < 0) {
      res->tv_usec += 1000000;
      res->tv_sec -= 1;
    }
  }
}

/* for adding usecs to a timeval */
void incTimeval(struct timeval *tv, int usec) 
{
  if (usec >= 0) {
    while (usec > 1000000) {
      tv->tv_sec++;
      usec -= 1000000;
    }
    tv->tv_usec += usec;
    if (tv->tv_usec >= 1000000) {
      tv->tv_usec -= 1000000;
      tv->tv_sec += 1;
    }
  }
  else {
    while (usec < -1000000) {
      tv->tv_sec--;
      usec += 1000000;
    }
    tv->tv_usec -= usec;
    if (tv->tv_usec < 0) {
      tv->tv_usec += 1000000;
      tv->tv_sec -= 1;
    }
  }
}

void printTimeval(struct timeval *tv)
{
  printf("%d.%06d", tv->tv_sec, tv->tv_usec);
}

