#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <unistd.h>
#include <errno.h>
#include "ioutil.h"

/* [buf2int(b)] converts the buffer [b] having size 4 into a 32 bit 
   integer, assuming host byte order. */
static int buf2int(char *buf)
{
  int i, x = 0;
  int shiftAmt = 0;
  assert(4 == sizeof(int));
  for (i = 0; i<4; i++, shiftAmt += 8) {
    int z = ((int)buf[i] & 0xff) << shiftAmt;
    x += z;
//      fprintf(stderr,"buf[%d] = %d\n",i,buf[i]);
//      fprintf(stderr,"x = %d\n",x);
  }
  return x;
}

void int2buf(int x, char* buf)
{
  int i;
  for (i = 0; i<4; i++)
    buf[i] = (char)((x >> (i*8)) & 0xff);
}

/* [readPacket(fd,buf,ofs)] reads in a "packet" from socket [fd].  If
   [buf] is NULL, then it reads the length of the packet first, allocates
   a buffer of that length, and returns it in s.  If [buf] is not
   NULL, then reading starts at [ofs] within the buffer until it fills.
   The number of characters read is returned. */
int readPacket(int fd, char** s, int *sz, int ofs) {
  int ret;
  /* haven't read it yet */
  if (*s == NULL) {
    char buf[4];
    int ret = readn(fd,buf,4);
    if (ret != 4)
      if (ret <= 0)
	return ret; /* errno set by readn() */
      else {
	fprintf(stderr,"%s:%d: failed to read pkt len (ret %d != 4)\n",
		__FILE__,__LINE__,ret);
	exit(1);
      }
    else {
      int len = buf2int(buf);
      char * str = malloc(len);
      if (str != NULL) {
//        fprintf(stderr,"read len = %d, str.size = %d\n", len, str.size);
	*s = str;
	*sz = len;
	ofs = 0;
      }
      else {
	fprintf(stderr,"%s:%d: malloc(%d) failed\n",
		__FILE__,__LINE__,len);
	exit(1);
      }
    }
  }
  
//    fprintf(stderr,"read packet length %d\n",(*s).size-ofs);

 again:
  ret = read(fd,(*s + ofs),*sz - ofs);
  if ((ret < 0) && (errno == EINTR))
    goto again;
  return ret;
}

/* [sendPacket(fd,buf,ofs)] sends the buffer [buf], starting at offset
   [ofs], along connection [fd].  Returns the number of characters
   written. */
int sendPacket(int fd, char * s, int ofs, int len) {

  int ret;

  if (ofs == 0) /* write the length */ {
    char buf[4] = { 0, 0, 0, 0 };
    int2buf(len,buf);
//      printf("buf = [%x][%x][%x][%x]\n",buf[0],buf[1],buf[2],buf[3]);
  retry:
    ret = writen(fd,(char *)buf,4);
    if (ret < 0) 
      if (errno == EINTR)
	goto retry;
      else
	return ret;
  }
  if (len == 0) return 0;

 again:
  ret = write(fd,s + ofs,len);
  if ((ret < 0) && (errno == EINTR))
    goto again;
  return ret;
}
