/* This file is part of the MediaNet Project.
   Copyright (C) 2002-2004 Michael Hicks

   MediaNet is free software; you can redistribute it and/or it
   under the terms of the GNU Lesser General Public License as
   published by the Free Software Foundation; either version 2.1 of
   the License, or (at your option) any later version.

   MediaNet is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with this library; see the file COPYING.LIB.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place, Suite
   330, Boston, MA 02111-1307 USA. */

#ifndef __COMPUTIL_H__
#define __COMPUTIL_H__

#include <core.h>

struct AvgCounter<`r::R> {
  double ?`r bins;	// bins
  double aggregate;	// current aggregrate for bins
  int currIdx;		// current index in arrays
  bool wrappedAround;	// whether the arrays have wrapped around
};

extern struct AvgCounter<`r> initCounter(double ?`r bins);
extern void resetCounter(struct AvgCounter @counter);
extern void addReading(struct AvgCounter @counter, 
		       double reading, double @aggregate);

#endif
