/* This file is part of the MediaNet Project.
   Copyright (C) 2002-2004 Michael Hicks

   MediaNet is free software; you can redistribute it and/or it
   under the terms of the GNU Lesser General Public License as
   published by the Free Software Foundation; either version 2.1 of
   the License, or (at your option) any later version.

   MediaNet is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with this library; see the file COPYING.LIB.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place, Suite
   330, Boston, MA 02111-1307 USA. */

/* Modification of the following: */

/* snap-1.0. Copyright (C) 2000 by Jonathan T. Moore and Michael Hicks.
 *
 * d_printf.h: debugging messages. Can be easily compiled out by
 *   setting the -DNDEBUG flag. Verbosity level controlled by setting
 *   the environment variable DEBUG_LEVEL. If DEBUG_LEVEL = -1, then
 *   _all_ debugging messages will be printed. Otherwise, only those
 *   messages with a debug level less than DEBUG_LEVEL will be printed
 *   (so DEBUG_LEVEL = 0 produces no messages).
 *
 * $Id: d_printf.h,v 1.2 2004/10/13 02:33:55 mwh Exp $
 */

#ifndef _DPRINTF_H_
#define _DPRINTF_H_

#include "debug_level.h"

#ifdef NDEBUG
#define d_printf
#define set_debug_level
#define debug_print_time
#define d_printfunc
#else
#include <stdio.h>
extern int debug_level;
extern void _dprintf_func(int lvl, 
			  const char ?`r fmt, ... inject parg_t<`r2> ap)
  __attribute__((format(printf,2,3)));
#define d_printf _dprintf_func
#define d_printfunc(lvl,f,arg...) (lvl <= debug_level ? f ## (##arg) : 0)

extern int debug_level;
extern void set_debug_level(); // gets level from env variable
extern void set_debug_print_time(int); // sets whether to print time on msgs
#endif /* NDEBUG */

#endif /* !_DPRINTF_H_ */
