/* This file is part of the MediaNet Project.
   Copyright (C) 2002-2004 Michael Hicks

   MediaNet is free software; you can redistribute it and/or it
   under the terms of the GNU Lesser General Public License as
   published by the Free Software Foundation; either version 2.1 of
   the License, or (at your option) any later version.

   MediaNet is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with this library; see the file COPYING.LIB.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place, Suite
   330, Boston, MA 02111-1307 USA. */

#ifndef _HTTP_H_
#define _HTTP_H_

#include <sys/stat.h>
#include <core.h>
#include <list.h>

#define STAT stat
//  #define STAT stat_t

#ifndef MAX
#define MAX(a,b) ((a) > (b) ? (a) : (b))
#endif
#ifndef MIN
#define MIN(a,b) ((a) < (b) ? (a) : (b))
#endif

#define SERVER_SOFTWARE "medianet-0.1" /* (modified minihttpd/1.15c) */
#define SERVER_URL "http://www.cs.cornell.edu/people/mhicks"
#ifdef USE_SSL
#define DEFAULT_HTTPS_PORT 443
#define CERT_FILE "cert.pem"
#define KEY_FILE "key.pem"
#endif /* USE_SSL */

#define METHOD_GET 1
#define METHOD_HEAD 2
#define METHOD_POST 3

#define ERR_DIR "errors"
#define DEFAULT_HTTP_PORT 80

extern char ? hostname;

/************************ POST processing code ************************/

struct Map<`r::R,`r2::R> {
  char ?`r key;
  char ?`r2 val;
};
typedef struct Map<`r1,`r2> @`r3 map_t<`r1,`r2,`r3>;

extern char ?`r lookup(List::list_t<map_t<`r,`r,`r2>,`r3> postmap, const char ? key);
extern List::list_t<map_t<`r,`r,`r2>,`r2> post_strdecode( region_t<`r2> rgn, 
							  char?`r source );

/* url must be of the form http://host-name[:port]/file-name */
extern void
postURL( int sockfd, string_t<`r> url, string_t referer, string_t user_agent, 
	 string_t auth_token, string_t cookie, mstring_t? args, int argc );

extern void
postURLbyParts( int sockfd, string_t host, 
		string_t file, string_t referer, string_t user_agent,
		string_t auth_token, string_t cookie, mstring_t? args,
		int argc );

/*************************** HTTP request struct ************************/

/* Request variables. */
/* information gathered about a HTTP request */
struct request_info<`r::R> {
  region_t<`r> rgn_request;
  int conn_fd;
#ifdef USE_SSL
  SSL*`r ssl;
#endif /* USE_SSL */
//    usockaddr client_addr;
  struct sockaddr_in client_addr;
  bool one_one;
  bool mime_flag;
  char?`r request;
  int request_size, request_len, request_idx;
  int method;
  char?`r path;
  char?`r file;
  struct STAT sb;
  char?`r query;
  const char?`r protocol;
  int status;
  long bytes;
  char?`r req_hostname;
  char?`r content;
  List::list_t<map_t<`r,`r,`r>,`r> post_map;

  char?`r authorization;
  long content_length;
  char?`r content_type;
  char?`r cookie;
  char?`r accept;
  char?`r accepte;
  char?`r host;
  char?`r hostdir;
  time_t if_modified_since, range_if;
  const char?`r referer;
  const char?`r useragent;
  off_t init_byte_loc, end_byte_loc;
  off_t contentlength;
  bool keep_alive;
  bool should_linger;
  bool got_range;

  char?`r remoteuser;
#ifndef NDEBUG
  char?`r orig_request;
#endif
}; 
typedef struct request_info<`r1> @`r request_info_t<`r1,`r>;

struct error_info<`r::R> {
  int resp_code;
  const char ?`r header;
  const char ?`r extra_header;
  const char ?`r error;
};
typedef struct error_info<`r1> *`r error_info_t<`r1,`r>;

/* Parses an HTTP request */
extern error_info_t<`r,`r> parse_http_request( region_t<`r> rgn, 
					       request_info_t<`r> );

/* Initializes the host address and file logging */
extern void http_initialize( const char ?user_logfile, 
			     const char ?user_hostname );

/* Shell-style pattern matcher---does *, **, and ? */
extern int match( const char? pattern, const char? string );

/* Reads in an HTTP command from the given file descriptor and 
   immediately responds on the same fd. */
extern void handle_request( int conn_fd, struct sockaddr_in @client_addr );

extern void print_req(request_info_t req);

extern void read_post_data( request_info_t req );

/* Sending replies to HTTP requests; one takes a buffer, one takes
   a zero-terminated string. */
extern void send_reply_buf( request_info_t req, int s, const char? title,
			    const char? extra_header, const char? type, 
			    const char? @nozeroterm text, int len );

extern void send_reply_text( request_info_t req, int s, const char? title,
			     const char? extra_header, const char? type, 
			     const char? text, int len );

/* Sends an error in response to a bad request; user-defined args are
   all strings. */
extern void send_error( request_info_t req, int s, 
			const char? title, const char? extra_header, 
			const char? text );


#endif
