/* This file is part of the MediaNet Project.
   Copyright (C) 2002-2004 Michael Hicks

   MediaNet is free software; you can redistribute it and/or it
   under the terms of the GNU Lesser General Public License as
   published by the Free Software Foundation; either version 2.1 of
   the License, or (at your option) any later version.

   MediaNet is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with this library; see the file COPYING.LIB.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place, Suite
   330, Boston, MA 02111-1307 USA. */

#ifndef _IOUTIL_H_
#define _IOUTIL_H_

#include <sys/types.h>
#include <stdio.h>
#include <core.h>

extern ssize_t readn(int fd, char ? @nozeroterm buf, size_t count, bool @err);
extern ssize_t writen(int fd, const char ? @nozeroterm buf, size_t count, 
		      bool @err);
extern ssize_t readline(int fd, char ? buf, size_t maxlen);
extern char ? @nozeroterm `U readFile(FILE @fp);
extern void printBuf(char ? @nozeroterm);

#endif
