/* This file is part of the MediaNet Project.
   Copyright (C) 2002-2004 Michael Hicks

   MediaNet is free software; you can redistribute it and/or it
   under the terms of the GNU Lesser General Public License as
   published by the Free Software Foundation; either version 2.1 of
   the License, or (at your option) any later version.

   MediaNet is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with this library; see the file COPYING.LIB.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place, Suite
   330, Boston, MA 02111-1307 USA. */

/* Contains references to C routines that perform simple MPEG operations.
   Eventually we might want to all more general access to DALI operations. */

#ifndef _MPEG_H_
#define _MPEG_H_

/*----------------------------------------------------------------------*/
/* MPEG DELIMITER CODES */

#define PeekInt(p, retval)\
{\
    unsigned char ? @nozeroterm _c;\
    _c = (unsigned char ? @nozeroterm)(p);\
    retval = (unsigned int)(*_c++ << 24);\
    retval |= (unsigned int)(*_c++ << 16);\
    retval |= (unsigned int)(*_c++ << 8);\
    retval |= (unsigned int)(*_c);\
}
#define GetCurrStartCode PeekInt

#define SEQ_START_CODE 0x000001b3
#define SEQ_END_CODE   0x000001b7
#define ISO_11172_END_CODE 0x000001b9
#define PACK_START_CODE 0x000001ba
#define SYS_START_CODE 0x000001bb
#define PIC_START_CODE 0x00000100
#define GOP_START_CODE 0x000001b8
#define EXT_START_CODE 0x000001b5
#define USER_START_CODE 0x000001b2
#define SLICE_MIN_START_CODE 0x00000101
#define SLICE_MAX_START_CODE 0x000001af
#define PACKET_MIN_START_CODE 0x0000001bc
#define PACKET_MAX_START_CODE 0x0000001f0

/*----------------------------------------------------------------------*/
/* MPEG SEQUENCE HEADERS */

  typedef struct MpegSeqHdr {
      short width;            /* width of each frame */
      short height;           /* height of each frame */
      short mb_width;         /* width of each frame in macroblocks */
      short mb_height;        /* height of each frame in macroblocks */
      int bitrate;            /* In units of 400 bits/second */
      int vbv_buffer_size;    /* Decoding verifier buffer size */
      char pel_aspect_ratio;  /* Index to aspect ratio table */
      char picture_rate;      /* Index to picture rate table */
      char constrained;       /* Boolean - true if a constrained param mpeg */
      char default_qt;        /* 0 - both, 1 - iqt, 2 - niqt, 3 - none */
      unsigned char iqt[64];  /* Intra quantization table - 64 elements */
      unsigned char niqt[64]; /* Non intra quantization table */
  } MpegSeqHdr;

extern "C" int parseMpegSeqHdr(char @ @nozeroterm buf, 
			       int bufsz, MpegSeqHdr @hdr);
extern "C" double MpegSeqHdrGetPicRate(MpegSeqHdr @);

#define MpegSeqHdrGetWidth(hdr) (hdr)->width
#define MpegSeqHdrGetHeight(hdr) (hdr)->height

extern "C" int makeNullPFrame(char @ @nozeroterm buf, 
			      int bufsz, short width, short height);

/*----------------------------------------------------------------------*/
/* MPEG PIC HEADERS */

#define I_FRAME 1
#define P_FRAME 2
#define B_FRAME 3
#define D_FRAME 4

#define FRAME_TYPE(p) ((((const unsigned char @{6} @nozeroterm)(p))[5] >> 3) & 0x0007)

#define GET_TEMPORAL_REF(p,ret)			\
{ (ret) = 0;					\
  (ret) = (p)[4] << 2;				\
  (ret) |= ((p)[5] & 0xc0) >> 6;		\
}

#define SET_TEMPORAL_REF(x,ref)					\
{ (x)[4] = (char)((ref >> 2) & 0xff);				\
  (x)[5] = (char)(((x)[5] & 0x3f) | ((ref << 6) & 0xc0));	\
}

#endif
