/* This file is part of the MediaNet Project.
   Copyright (C) 2002-2004 Michael Hicks

   MediaNet is free software; you can redistribute it and/or it
   under the terms of the GNU Lesser General Public License as
   published by the Free Software Foundation; either version 2.1 of
   the License, or (at your option) any later version.

   MediaNet is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with this library; see the file COPYING.LIB.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place, Suite
   330, Boston, MA 02111-1307 USA. */

/* port.h - portability defines */

#if defined(__FreeBSD__)
# define FreeBSD
# define ARCH "FreeBSD"
#else
# if defined(linux)
#  define Linux
#  define ARCH "Linux"
# else
#  if defined(sun)
#   define Solaris
#   define ARCH "Solaris"
#  else
#   define UNKNOWN
#   define ARCH "UNKNOWN"
#  endif
# endif
#endif

#ifdef FreeBSD
# include <osreldate.h>
# define HAVE_DAEMON
# define HAVE_SETSID
# define HAVE_SETLOGIN
# define HAVE_WAITPID
# define HAVE_HSTRERROR
# define HAVE_TM_GMTOFF
# define HAVE_SENDFILE
# ifdef SO_ACCEPTFILTER
#  define HAVE_ACCEPT_FILTERS
#  if ( __FreeBSD_version >= 411000 )
#   define ACCEPT_FILTER_NAME "httpready"
#  else
#   define ACCEPT_FILTER_NAME "dataready"
#  endif
# endif /* SO_ACCEPTFILTER */
#endif /* FreeBSD */

#ifdef Linux
# define HAVE_DAEMON
# define HAVE_SETSID
# define HAVE_WAITPID
//# define HAVE_SENDFILE
#endif /* Linix */

#ifdef Solaris
# define HAVE_SETSID
# define HAVE_WAITPID
# define HAVE_MEMORY_H
#endif /* Solaris */

#ifdef USE_IPV6
# define HAVE_SOCKADDR_IN6
# define HAVE_SOCKADDR_STORAGE
# define HAVE_GETADDRINFO
# define HAVE_GETNAMEINFO
# define HAVE_GAI_STRERROR
#endif /* USE_IPV6 */
