/* This file is part of the MediaNet Project.
   Copyright (C) 2002-2004 Michael Hicks

   MediaNet is free software; you can redistribute it and/or it
   under the terms of the GNU Lesser General Public License as
   published by the Free Software Foundation; either version 2.1 of
   the License, or (at your option) any later version.

   MediaNet is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with this library; see the file COPYING.LIB.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place, Suite
   330, Boston, MA 02111-1307 USA. */

#ifndef _SERVER_H_
#define _SERVER_H_

#include <sys/types.h>
#include <unistd.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netdb.h>

#define LISTEN_BACKLOG 1024

extern datatype exn { extern ServerOpFailed(string_t,int) };

extern struct sockaddr_in GetAddr(unsigned short port, string_t hostname);

extern int OpenSocket(bool nonBlock, bool isStream);
extern int OpenListen(unsigned short port, string_t hostname, bool nonBlock,
		      bool isStream);
extern int OpenConnect(unsigned short port, string_t hostname,
		       bool nonBlock, bool isStream);
extern int RespondAccept(int fd, struct sockaddr_in @sin, bool nonBlock);
extern bool isNonBlock(int fd);

#endif
