/* This file is part of the MediaNet Project.
   Copyright (C) 2002-2004 Michael Hicks

   MediaNet is free software; you can redistribute it and/or it
   under the terms of the GNU Lesser General Public License as
   published by the Free Software Foundation; either version 2.1 of
   the License, or (at your option) any later version.

   MediaNet is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with this library; see the file COPYING.LIB.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place, Suite
   330, Boston, MA 02111-1307 USA. */

#ifndef __TIMEVAL_UTIL_H__
#define __TIMEVAL_UTIL_H__

#include <core.h>
#include <sys/time.h>

extern int timevalCmp(struct timeval @tv1, struct timeval *tv2);
extern void subTimeval(struct timeval *tv1, struct timeval @tv2, struct timeval @res);
extern void incTimeval(struct timeval @tv, int usec);
extern void printTimeval(struct timeval @tv);

/* for profiling */

struct profile_timer {
  struct timeval startTime;
  struct timeval endTime;
  string_t<`H> name;
};

#define TIMER(__timer,__name)					\
  struct profile_timer __timer = { timeval(0,0), timeval(0,0), __name }

#define START_TIME(__timer) 			\
  gettimeofday(&((__timer).startTime),NULL)

#define END_TIME(__timer)					\
  gettimeofday(&((__timer).endTime),NULL);			\
  subTimeval(&((__timer).endTime),&((__timer).startTime),	\
	     &((__timer).endTime));				\
  fprintf(stderr,"%s time = %d.%06d secs\n",			\
	  (__timer).name,(__timer).endTime.tv_sec,		\
	  (__timer).endTime.tv_usec)



#endif
