/* This file is part of the MediaNet Project.
   Copyright (C) 2002-2004 Michael Hicks

   MediaNet is free software; you can redistribute it and/or it
   under the terms of the GNU Lesser General Public License as
   published by the Free Software Foundation; either version 2.1 of
   the License, or (at your option) any later version.

   MediaNet is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with this library; see the file COPYING.LIB.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place, Suite
   330, Boston, MA 02111-1307 USA. */

#ifndef _CONFIGURE_H_
#define _CONFIGURE_H_

#include <core.h>
#include <xml/xml.h>
#include <list.h>
#include "component.h"

enum FlowType { Packetized, Unpacketized };

namespace Configure {

using Xml;
using List;
using Component;

  /**** helper functions for parsing XML attributes ****/

extern string_t<`r> getStringFromAtt(attvalue_t<`r> att);
extern int getIntFromAtt(attvalue_t att);
extern double getDoubleFromAtt(attvalue_t att);

  /**** Component configurations ****/

struct Compinfo<`r::R>;
typedef struct Compinfo<`r> @`r compinfo_t<`r>;

datatype Comptype<`r::R> {
  Send(string_t host, unsigned short port, bool isConnect, enum FlowType t,
       bool isStream, string_t link, bool user_origin, bool no_drops,
       list_t<compinfo_t<`r>,`r> sources);
  Recv(string_t host, unsigned short port, bool isAccept, enum FlowType t,
       bool isStream, string_t link, bool user_origin);
  Op(string_t nm, list_t<attribute_t> args);
  CompUnknown;
};	 

typedef datatype Comptype<`r> @`r comptype_t<`r>;

struct Compinfo<`r::R> {
  string_t<`H> compname;
  double rate;
  comptype_t<`r> type;
  list_t<compinfo_t<`r>,`r> outputs;
};  

extern list_t<compinfo_t<`r>,`r> parseConfigurationFile(region_t<`r> r,FILE @`H fp);
extern list_t<compinfo_t<`r>,`r> parseConfigurationFilefromString(region_t<`r> r, buffer_t doc);
extern buffer_t currentConfiguration(void);

  /**** Test setup configurations ****/

datatype TestSetupConfig {
  SendBW(string_t compId, double bw);
};	 
typedef datatype TestSetupConfig @`r testsetupconfig_t<`r>;

extern list_t<testsetupconfig_t<`r>,`r> parseTestConfig(region_t<`r> r,FILE @`H fin);
extern list_t<testsetupconfig_t<`r>,`r> parseTestConfigfromString(region_t<`r> r,buffer_t doc);
extern buffer_t currentTestConfiguration(void);

}

#endif
