/* This file is part of the MediaNet Project.
   Copyright (C) 2002-2004 Michael Hicks

   MediaNet is free software; you can redistribute it and/or it
   under the terms of the GNU Lesser General Public License as
   published by the Free Software Foundation; either version 2.1 of
   the License, or (at your option) any later version.

   MediaNet is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with this library; see the file COPYING.LIB.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place, Suite
   330, Boston, MA 02111-1307 USA. */

#ifndef __FRAME_H__
#define __FRAME_H__

// #define NO_FREE

#ifndef NO_FREE

#include "streambuff.h"

typedef streambuff_t<`U> frame_t;
typedef streambuff_opt_t<`U> frame_opt_t;

#define data_region Core::refcnt_region
#define DATA_REGION `RC

#define frame_clone(stb) stb_clone(Core::unique_region,stb)
#define frame_free(stb) stb_free_unique(stb)
#define frame_copy(stb) stb_copy(Core::unique_region,0,stb)
#define alloc_frame_with(typ,link,ofs,dbuf) alloc_stb_with(Core::unique_region,typ,link,ofs,dbuf)
#define alloc_frame(typ,link,ofs,buf) alloc_stb(Core::unique_region,typ,link,ofs,buf)
#define frame_prepend(stb,buf) stb_prepend(Core::unique_region,stb,buf)
#define frame_info stb_info
#define frame_size stb_size
#define frame_with_buffer stb_with_buffer
#define frame_rest stb_rest
#define frame_num_bufs stb_num_bufs
#define frame_with_buffer stb_with_buffer

#else

#include "streambuff-heap.h"

typedef streambuff_t<`H> frame_t;
typedef streambuff_opt_t<`H> frame_opt_t;

#define data_region Core::heap_region
#define DATA_REGION `H

#define frame_clone(stb) HeapStreamBuff::stb_clone(Core::heap_region,stb)
#define frame_free(stb) HeapStreamBuff::stb_free(stb)
#define frame_copy(stb) HeapStreamBuff::stb_copy(Core::heap_region,0,stb)
#define alloc_frame_with(typ,link,ofs,dbuf) HeapStreamBuff::alloc_stb_with(Core::heap_region,typ,link,ofs,dbuf)
#define alloc_frame(typ,link,ofs,buf) HeapStreamBuff::alloc_stb(Core::heap_region,typ,link,ofs,buf)
#define frame_prepend(stb,buf) HeapStreamBuff::stb_prepend(Core::heap_region,stb,buf)
#define frame_info HeapStreamBuff::stb_info
#define frame_size HeapStreamBuff::stb_size
#define frame_with_buffer HeapStreamBuff::stb_with_buffer
#define frame_rest HeapStreamBuff::stb_rest
#define frame_num_bufs HeapStreamBuff::stb_num_bufs
#define frame_with_buffer HeapStreamBuff::stb_with_buffer

#endif

#endif
