/* This file is part of the MediaNet Project.
   Copyright (C) 2002-2004 Michael Hicks

   MediaNet is free software; you can redistribute it and/or it
   under the terms of the GNU Lesser General Public License as
   published by the Free Software Foundation; either version 2.1 of
   the License, or (at your option) any later version.

   MediaNet is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with this library; see the file COPYING.LIB.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place, Suite
   330, Boston, MA 02111-1307 USA. */

#ifndef _LINK_H_
#define _LINK_H_

#include <core.h>
#include <set.h>
#include <sys/time.h>
#include "arrqueue.h"
#include "monitor.h"
#include "frame.h"

struct conn<`r::R>;

/** structure that keeps information about an underlying network
    link (i.e. and Ethernet device) **/
struct LinkInfo<`r::R> {
  string_t name;		// link name (e.g. eth0)
  bool isBlocked;		// indicates whether sending > link capacity

  /* for monitoring the bandwidth */
  struct countState<`H> @`H sentCounter;
  struct countState<`H> @`H droppedCounter;

  /* for fairly sharing the link among different connections */
  Set::set_t<ArrQueue::aqueue_t<frame_opt_t,`r>> linkQueues;
  unsigned int linkQueueLen;
  unsigned int maxQLen;
};
typedef struct LinkInfo<`r> @`r2 linkinfo_t<`r,`r2>;
typedef struct LinkInfo<`r> *`r2 linkinfo_opt_t<`r,`r2>;

#define LINK_DEFAULT "default_network"

/** keep a table of all of the links we know about **/
extern void registerLinkInfo(string_t<`H> name, linkinfo_t<`H,`H> l);
extern linkinfo_t<`H,`H> getLinkInfo(string_t<`H> name, int qSize);

/** to associate queues/conns with this link **/
extern void registerSendConn(struct conn @c,
			     ArrQueue::aqueue_t<frame_opt_t,`r> q,
			     linkinfo_t<`r> l);
extern void unregisterSendConn(struct conn @c,
			       ArrQueue::aqueue_t<frame_opt_t,`r> q,
			       linkinfo_t<`r> l);

/** for dropping and queuing packets during congestion on this link **/
extern bool queueApacket(ArrQueue::aqueue_t<frame_opt_t,`r> currQ,
			 linkinfo_t<`r> link,
			 frame_t stb);

extern void reallyQueuePacket(linkinfo_t<`r> link,
			      ArrQueue::aqueue_t<frame_opt_t,`r> q,
			      frame_t stb,
			      bool doPush);

extern frame_t
dequeuePacket(linkinfo_t link,ArrQueue::aqueue_t<frame_opt_t> q);

/** purges all packets on this queue with >= given priority **/
extern void dropPackets(linkinfo_t link, int priority,
			ArrQueue::aqueue_t<frame_opt_t> q);

#endif
