/* This file is part of the MediaNet Project.
   Copyright (C) 2002-2004 Michael Hicks

   MediaNet is free software; you can redistribute it and/or it
   under the terms of the GNU Lesser General Public License as
   published by the Free Software Foundation; either version 2.1 of
   the License, or (at your option) any later version.

   MediaNet is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with this library; see the file COPYING.LIB.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place, Suite
   330, Boston, MA 02111-1307 USA. */

#ifndef _LOOP_H_
#define _LOOP_H_

#include <netinet/in.h>
#include <sys/socket.h>
#include <sys/select.h>
#include <fn.h>
#include <list.h>
#include <set.h>
#include "arrqueue.h"
#include "component.h"
#include "configure.h"
#include "link.h"
#include "schedule.h"

/** General information about connections */

struct ConnData<`r> {
  struct Core::DynamicRegion<`r>*`RC dyn;  
  component_t<`r> component; // connection writes to or from this component
  string_t hostname;        // host connected to/from
  unsigned short port;      // port connected to/from
  enum FlowType flowType;   // whether the data is raw or packetized
  bool isStream;            // whether the connection is TCP (else UDP)
};
struct ConnInfo<`r2> {
  <`r::R>
  struct ConnData<`r> @`r2 data;
};
typedef struct ConnInfo<`r> conninfo_t<`r>;

/** Connections sending data */

struct SendConnection<`r> {
  bool didAccept;
  conninfo_t<`r> connInfo;
  ArrQueue::aqueue_t<frame_opt_t,`H> sendQueue;
                             // queued packets under overload
  linkinfo_t<`H,`H> link;    // underlying link stats
  bool isUser;	             // if this goes outside medianet
  bool awaitingFirstConn;    // if this is the first conn following a reconfig
  bool isBlocked;	     // if this conn would block if we sent on it
  List::list_t<unsigned int> receivers;
  // list of Recv components whose output feed into this send op;
  // will only be non-NULL if this send op does backpressuring
};
typedef struct SendConnection<`r> @`r sendconn_t<`r>;

/** Connections receiving data */

struct RecvConnection<`r> {
  bool didAccept;
  conninfo_t<`r> connInfo;
  string_t link_name;	               // what link we are receiving from
  char ? @nozeroterm DATA_REGION buf;  // the packet currently being received
  int ofs;		               // the offset in buf to read into next
  bool isUser;	                       // if this comes from outside medianet
};
typedef struct RecvConnection<`r> @`r recvconn_t<`r>;

/** Pending connections */

@tagged union PendingConnection<`r> {
  recvconn_t<`r> receive;
  sendconn_t<`r> send;
};
typedef union PendingConnection<`r> pendconn_t<`r>;

/** Configuration and monitoring (HTTP) connections */

datatype ConfigConnection {
  CT_HttpServer;
  CT_HttpPendingPost;
  CT_HttpConn(struct sockaddr_in);
};
typedef datatype ConfigConnection @`r configconn_t<`r>;

/** Arbitrary connections */

@tagged union Connection<`r> {
  sendconn_t<`r>	sendConn;
  recvconn_t<`r>	recvConn;
  pendconn_t<`r>	pendConn;
  configconn_t<`r>	confConn;
};
typedef union Connection<`r> @`r conntype_t<`r>;

struct conn<`r> {
  int cnum;
  int fd;
  conntype_t<`r> typ;
};
typedef struct conn<`r> *`r conn_t<`r>;
typedef struct conn<`r> @`r nnconn_t<`r>;

/** For making use of dynamic regions */

struct DynCompinfoList {
  <`r::R>
  Core::uregion_key_t<`r> dyn;
  List::list_t<Configure::compinfo_t<`r>,`r> infos;
};

struct DynSchedCompList { <`d::R>
  Core::rcregion_key_t<`d> dyn;
  List::list_t<sched_comp_t<`d>,`d> schedcomps;
};
typedef struct DynSchedCompList *`r dynsched_comp_list_t<`r::TR>;

/** For configurations */

struct PostInfo {
  string_t hostname;
  unsigned short port;
  string_t uri;
  char ?? args;
};

#define MakeConnFDAssociation(hc, fd)  {fdToConnMap[(fd)] = (hc->cnum);}
#define ClearConnFDAssociation(fd) {fdToConnMap[(fd)] = -1;}
#define ISCONNFREE(x) (freeConnBits[(x)>>3] & (1<<((x)&7)))

typedef void (*SelectHandler<`r::R>)(conn_t<`r> c, int fd, int forRW);
#define SSH_NOTHING 0x0
#define SSH_READ 0x1
#define SSH_WRITE 0x2
#define SSH_ERR 0x4

/* This is <= the actual current time.  There is no guarantee as
   to how often it is updated, however, so don't rely on it being
   anything than less than the current time. */
extern struct timeval globalTimeOfDay;

/* Pending reconfiguration data.  If this is non-NULL, we are
   in the middle of a reconfiguration. */
extern Set::set_t<struct conn @`H> *`U pendingSendConns;

extern void doListen(pendconn_t<`H>);
extern int doConnect(pendconn_t<`H>, union Connection<`H> *`H retry);
extern void doHttpPost(struct PostInfo p);

extern void MainLoop(struct DynCompinfoList *`U infos);

extern unsigned short portnum;

extern void ShutDown();
extern void startReconfiguration(struct DynCompinfoList @`U infos);


/* parameters */
extern unsigned int send_queue_size;
extern int clear_queue_priority;
extern int snd_bufsz;

#define SECS_PRINT 10

#endif
