/* This file is part of the MediaNet Project.
   Copyright (C) 2002-2004 Michael Hicks

   MediaNet is free software; you can redistribute it and/or it
   under the terms of the GNU Lesser General Public License as
   published by the Free Software Foundation; either version 2.1 of
   the License, or (at your option) any later version.

   MediaNet is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with this library; see the file COPYING.LIB.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place, Suite
   330, Boston, MA 02111-1307 USA. */

#ifndef _MPEGCOMP_H_
#define _MPEGCOMP_H_

#include "component.h"
#include <core.h>

using Component;

extern component_t<`r>
new_MpegFrameDropComponent(region_t<`r> r, string_t id, int dropFlags);
/** [MpegFrameDropComponent(id,fl)] assumes its input is an
    MPEG frame, and drops frames as indicated by the dropFlags.
    If [fl] == 1, then all B frames are dropped; if [fl] == 2
    then both P and B frames are dropped. */

extern component_t<`r>
new_MpegFrameSeqDropComponent(region_t<`r> r, string_t id, int dropFlags);
/** [MpegFrameSeqDropComponent(id,fl)] has the same functionality
    as [MpegFrameDropComponent(id,fl)] except that the input
    is assumed to have a preceding sequence number, instead
    of just being an MPEG frame. */

#ifdef NOTDEF
extern component_t<`r>
new_MpegFrameSeqRestoreComponent(string_t id, short width, short height);
/** [MpegFrameSeqRestoreComponent(id,w,h)] notices missing sequence
    numbers and inserts dummy MPEG frames in their place in
    the stream.  In addition, it strips the sequence numbers
    from any other frames received.  The dummy frames are
    calculated based on the given width [w] and height [h]
    parameters; if these are 0, it looks in the stream for
    the sequence header to get these values. */
#endif

extern component_t<`r> new_MpegFramePriorityComponent(region_t<`r>, string_t);
/** [MpegFramePriorityComponent(r,id)] sets the drop priority of
    MPEG packets based on the frame type. */

extern component_t<`r> new_MpegFrameSeqPriorityComponent(region_t<`r>,string_t);
/** [MpegFrameSeqPriorityComponent(r,id)] sets the drop priority of
    MPEG packets based on the frame type; assumes data has sequence
    number prepended. */

#endif
