/* This file is part of the MediaNet Project.
   Copyright (C) 2002-2004 Michael Hicks

   MediaNet is free software; you can redistribute it and/or it
   under the terms of the GNU Lesser General Public License as
   published by the Free Software Foundation; either version 2.1 of
   the License, or (at your option) any later version.

   MediaNet is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with this library; see the file COPYING.LIB.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place, Suite
   330, Boston, MA 02111-1307 USA. */

/* This could modified from pqueue.c code by Georg Kraml,
   http://purists.org/pqueue */ 

#ifndef _PQUEUE_H_
#define _PQUEUE_H_

#include <core.h>

/*
 *  Priority queue structure
 */
struct pqueue<`a>
{
  int size, avail, step;
  int (@getprio)(`a);
  `a ?`U d;
};

/*
 *  Functions
 */
extern struct pqueue<`a> @`r pqinit(region_t<`r::TR> r,
				    int n, int (@`H getprio)(`a), `a def);
extern void pqinsert(struct pqueue<`a> @q, `a d);
extern `a pqremove(struct pqueue<`a> @q);
extern `a pqpeek(struct pqueue<`a> @q);
extern void pqfree(struct pqueue<`a> @`U q);

#endif
