/* This file is part of the MediaNet Project.
   Copyright (C) 2002-2004 Michael Hicks

   MediaNet is free software; you can redistribute it and/or it
   under the terms of the GNU Lesser General Public License as
   published by the Free Software Foundation; either version 2.1 of
   the License, or (at your option) any later version.

   MediaNet is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with this library; see the file COPYING.LIB.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place, Suite
   330, Boston, MA 02111-1307 USA. */

#ifndef _SCHEDULE_H_
#define _SCHEDULE_H_

#include "component.h"
#include <sys/time.h>
#include <list.h>

struct SchedComp<`r::R> {
  Component::component_t<`r> comp;
  struct timeval deadline;
};
typedef struct SchedComp<`r> @`r sched_comp_t<`r::R>;

extern List::list_t<sched_comp_t<`r>,`r>
initializeComponents(region_t<`r> r,
		     List::list_t<Component::component_t<`r>,`r> comps);

struct SchedFn<`bd::R> {
  <`arg> : regions(`arg) > `bd
  bool (@f)(`arg);
  `arg argument;
  struct timeval deadline;
};

typedef struct SchedFn<`r> @sched_fn_t<`r>;

extern struct timeval
registerTimeout(List::list_t<sched_fn_t<`H>> @timers, 
		bool (@`H handler)(`a), `a arg, 
		struct timeval @`r currTime,
		unsigned int secsTimeout,
		unsigned int usecsTimeout : regions(`a) > `H);

/* Entry point for scheduling operations; does both user-defined
   handlers and components, and returns the next deadline (by
   returning true and setting nextDeadline), or false if none */
extern bool
invokeTimeoutComputations(struct timeval @`r tickval, 
			  List::list_t<sched_fn_t<`H>> @timers,
			  List::list_t<sched_comp_t<`d>,`d> myComponents,
			  List::list_t<sched_comp_t<`d2>,`d2> myComponentsPending,
			  struct timeval *`r setDeadline,
			  struct timeval @`r nextDeadline);

#endif
