/* This file is part of the MediaNet Project.
   Copyright (C) 2002-2004 Michael Hicks

   MediaNet is free software; you can redistribute it and/or it
   under the terms of the GNU Lesser General Public License as
   published by the Free Software Foundation; either version 2.1 of
   the License, or (at your option) any later version.

   MediaNet is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with this library; see the file COPYING.LIB.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place, Suite
   330, Boston, MA 02111-1307 USA. */

/* Defines components for adding sequence numbers to packets */

#ifndef _SEQCOMP_H_
#define _SEQCOMP_H_

#include "component.h"
using Component;

extern component_t<`r>
new_SeqAddComponent(region_t<`r> r, string_t id, unsigned int startNum);
/** [SeqAddComponent(id,seq)] prepends any packets it receives with
    a sequence number, starting with [seq], and incrementing by
    1.  This is done by prepending a new buffer and creating
    a PacketVector. */

extern frame_t seqStrip(frame_t stb,
			unsigned int @restoreKey,
			char ? @nozeroterm seqbuf,
			bool @err);
/** [seqStrip(v,seq)] assumes that the first four bytes of the Packet
    [v] is a sequence number, and adjusts the packet pointer past it.
    The stripped sequence number is returned in [seqbuf]. */

extern frame_t seqRestore(frame_t stb,
			  unsigned int restoreKey,
			  bool @err);
/** [seqRestore(v,b)] assumes that the sequence number in the Packet
    [v] has been stripped and adjusts the pointer to its buffer to restore it.
    based on the character buffer [b] which contains the stripped data. */ 

extern component_t<`r> new_SeqStripComponent(region_t<`r> r, string_t id);
/** [SeqStripComponent(id)] is a component that strips the sequence
    number from its incoming packets using seqStrip, above. */

extern component_t<`r> new_SeqPrintComponent(region_t<`r> r, string_t id);

#endif
