%{
#include <string.h>
#include "mmsched.h"
#include "brite.tab.h"

int id_var(void)
{
  if (!strncmp(yytext,"Topology",yyleng))
    return TOPOLOGY;
  else if (!strncmp(yytext,"Nodes",yyleng))
    return NODES;
  else if (!strncmp(yytext,"Model",yyleng))
    return MODEL;
  else if (!strncmp(yytext,"Edges",yyleng))
    return EDGES;
  else 
    return ID;
}

%}

/* regular definitions */

letter	[A-Za-z]
digit	[0-9]
id	{letter}({letter}|{digit}|_)*
int	({digit})+
float   {int}[.]{int}
%%

{id}			{ return id_var(); }
{int}			{ sscanf (yytext, "%d", &yylval.intval); return INT; }
{float}			{ sscanf (yytext, "%lf", &yylval.floatval); return FLOAT; }
[-]{int}		{ sscanf (yytext, "%d", &yylval.intval);
			  yylval.intval = -yylval.intval;
			  return INT; }
[-]{float}		{ sscanf (yytext, "%lf", &yylval.floatval); 
			  yylval.floatval = -yylval.floatval;
			  return FLOAT; }
[,]			{ return COMMA; }
[(]			{ return LPAREN; }
[)]			{ return RPAREN; }
[:]			{ return COLON; }
<<EOF>> 		{ yyterminate(); } 
[\n\t ]+
.
%%

int yywrap(void) {
  return 1;
}

