/* This file is part of the MediaNet Project.
   Copyright (C) 2002-2004 Michael Hicks, Robbert van Renesse.

   MediaNet is free software; you can redistribute it and/or it
   under the terms of the GNU Lesser General Public License as
   published by the Free Software Foundation; either version 2.1 of
   the License, or (at your option) any later version.

   MediaNet is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with this library; see the file COPYING.LIB.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place, Suite
   330, Boston, MA 02111-1307 USA. */

#include <stdlib.h>
#include <stdio.h>
#include <signal.h>
#include "oslib.h"

static void log_output(void *env, char *s){
	FILE *out = env;

	if (s != 0) {
		fprintf(out, "%s\n", s);
		fflush(out);
	}
}

int main(int argc, char **argv){
	struct ev_channel *dns, *dns_create(struct ev_channel *);
	struct socket_info *si;
	struct log_sub *log;

#ifdef WIN32
	WSADATA wsaData;

	(void) WSAStartup(MAKEWORD(2, 0), &wsaData);
#endif

#ifdef SIGPIPE
	signal(SIGPIPE, SIG_IGN);
#endif
#ifdef SIGHUP
	signal(SIGHUP, SIG_IGN);
#endif

	setbuf(stdout, 0);
	tst_init();
	log = log_subscribe(100, log_output, stderr);
	act_init();
	dns_init();

	/* Create a UDP socket.
	 */
	si = udp_create(argc == 1 ? 6543 : atoi(argv[1]));

	/* Create a DNS server activity.
	 */
	dns = dns_create(udp_output_create(si));

	/* Create a UDP input activity.
	 */
	udp_input_create(si, dns);

	/* Main loop.
	 */
	while (run_block())
		;

	dns_done();
	act_done();
	log_unsubscribe(log);
	Mem_Done();
	return 0;
}
