/* This file is part of the MediaNet Project.
   Copyright (C) 2002-2004 Michael Hicks, Robbert van Renesse.

   MediaNet is free software; you can redistribute it and/or it
   under the terms of the GNU Lesser General Public License as
   published by the Free Software Foundation; either version 2.1 of
   the License, or (at your option) any later version.

   MediaNet is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with this library; see the file COPYING.LIB.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place, Suite
   330, Boston, MA 02111-1307 USA. */

/* Some general purpose error routines.
 */

#include <errno.h>
#include "oslib.h"

int err_init(){
	log_init();
	return 1;
}

void err_log(char *s){
	log_printf("%s", s);
}

void err_warning(char *format, ...){
	va_list ap;

	log_prnt("Warning: ");
	va_start(ap, format);
	log_vprintf(format, ap);
	va_end(ap);
	log_flush(1);
}

void err_warning_posix(char *format, ...){
	va_list ap;

	log_prnt("Warning (Posix %d): ", 
	#ifdef WIN32
			WSAGetLastError()
	#else
			errno
	#endif
	);
	va_start(ap, format);
	log_vprintf(format, ap);
	va_end(ap);
	log_flush(1);
}

void err_warning_socket(char *format, ...){
	va_list ap;

	log_prnt("Warning (Socket %d): ",
	#ifdef WIN32
			WSAGetLastError()
	#else
			errno
	#endif
	);
	va_start(ap, format);
	log_vprintf(format, ap);
	va_end(ap);
	log_flush(1);
}

void err_fatal(char *format, ...){
	va_list ap;

	log_prnt("Fatal: ");
	va_start(ap, format);
	log_vprintf(format, ap);
	va_end(ap);
	log_flush(0);
	exit(1);
}

void err_fatal_posix(char *format, ...){
	va_list ap;

	log_prnt("Fatal (Posix %d): ",
	#ifdef WIN32
			WSAGetLastError()
	#else
			errno
	#endif
	);
	va_start(ap, format);
	log_vprintf(format, ap);
	va_end(ap);
	log_flush(0);
	exit(1);
}

void err_fatal_socket(char *format, ...){
	va_list ap;

	log_prnt("Fatal (Socket %d): ",
	#ifdef WIN32
			WSAGetLastError()
	#else
			errno
	#endif
	);
	va_start(ap, format);
	log_vprintf(format, ap);
	va_end(ap);
	log_flush(0);
	exit(1);
}
