CC = gcc
SRC = .
EXPAT = $(SRC)/import/expat
PARSE = $(EXPAT)/xmlparse
TOK = $(EXPAT)/xmltok
INCL = -I$(PARSE) -I$(TOK)
# CCFLAGS = -O2 -Wall $(INCL) -DDOS_ONLY
CCFLAGS = -O2 -Wall $(INCL)
CFLAGS = $(CCFLAGS)
LDFLAGS = $(CFLAGS)
OBJ = .o
OBJECTS = \
	hashtable$(OBJ) \
	xmlparse$(OBJ) \
	xmlrole$(OBJ) \
	xmltok$(OBJ)

expat.a: $(OBJECTS)
	ar -cr expat.a $(OBJECTS)

hashtable$(OBJ):	$(PARSE)/hashtable.c
	$(CC) -c $(CCFLAGS) $(PARSE)/hashtable.c
xmlparse$(OBJ):		$(PARSE)/xmlparse.c
	$(CC) -c $(CCFLAGS) $(PARSE)/xmlparse.c
xmlrole$(OBJ):		$(TOK)/xmlrole.c
	$(CC) -c $(CCFLAGS) $(TOK)/xmlrole.c
xmltok$(OBJ):		$(TOK)/xmltok.c
	$(CC) -c $(CCFLAGS) $(TOK)/xmltok.c
