/* This file is part of the MediaNet Project.
   Copyright (C) 2002-2004 Michael Hicks, Robbert van Renesse

   MediaNet is free software; you can redistribute it and/or it
   under the terms of the GNU Lesser General Public License as
   published by the Free Software Foundation; either version 2.1 of
   the License, or (at your option) any later version.

   MediaNet is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with this library; see the file COPYING.LIB.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place, Suite
   330, Boston, MA 02111-1307 USA. */

#include <stdio.h>
#include <stdlib.h>
#include <sys/time.h>

/**** TEMPLATES for user specs ****/

/* parms: source-num source-pc source-num source-pc source-num
   dest-num dest-pc source-num */ 
static char *util1_spec = "
  <alt utility=\"1.0\">
	<comp name=\"recv%d\">
	  <op cmd=\"recv\" port=\"5001\" size=\"4800\"/>
	  <location>pc%d</location>
	  <interval>0.033</interval>
	</comp>

        <comp name=\"prio%d\">
          <op cmd=\"Seq_MPEG_prio\" size=\"4800\"/>
	  <location>pc%d</location>
	  <interval>0.033</interval>
          <inputs>
            <input name=\"recv%d\"/>
          </inputs>
        </comp>

	<comp name=\"send%d\">
	  <op cmd=\"send\" host=\"localhost\" port=\"5000\"/>
	  <location>pc%d</location>
	  <inputs>
		<input name=\"prio%d\"/>
	  </inputs>
	  <interval>0.033</interval>
	</comp>
  </alt>";

/* parms: source-num source-pc source-num source-pc source-num
   source-num source-num dest-num dest-pc source-num */ 
static char *util05_spec = "
  <alt utility=\"0.5\">
	<comp name=\"recv%d\">
	  <op cmd=\"recv\" port=\"5001\" size=\"4800\"/>
	  <location>pc%d</location>
	  <interval>0.033</interval>
	</comp>

        <comp name=\"prio%d\">
          <op cmd=\"Seq_MPEG_prio\" size=\"4800\"/>
	  <location>pc%d</location>
	  <interval>0.033</interval>
          <inputs>
            <input name=\"recv%d\"/>
          </inputs>
        </comp>

	<comp name=\"dropFramesX%d\">
	  <op cmd=\"Seq_MPEG_drop\" frametypes=\"B\" size=\"8800\"/>
	  <inputs>
		<input name=\"prio%d\"/>
	  </inputs>
	  <interval>0.1</interval>
	</comp>

	<comp name=\"send%d\">
	  <op cmd=\"send\" host=\"localhost\" port=\"5000\"/>
	  <location>pc%d</location>
	  <inputs>
		<input name=\"dropFramesX%d\"/>
	  </inputs>
	  <interval>0.1</interval>
	</comp>
  </alt>";

/* parms: source-num source-pc source-num source-pc source-num
   source-num source-num dest-num dest-pc source-num */ 
static char *util01_spec = "
  <alt utility=\"0.1\">
	<comp name=\"recv%d\">
	  <op cmd=\"recv\" port=\"5001\" size=\"4800\"/>
	  <location>pc%d</location>
	  <interval>0.033</interval>
	</comp>

        <comp name=\"prio%d\">
          <op cmd=\"Seq_MPEG_prio\" size=\"4800\"/>
	  <location>pc%d</location>
	  <interval>0.033</interval>
          <inputs>
            <input name=\"recv%d\"/>
          </inputs>
        </comp>

	<comp name=\"dropFramesX%d\">
	  <op cmd=\"Seq_MPEG_drop\" frametypes=\"PB\" size=\"13500\"/>
	  <inputs>
		<input name=\"prio%d\"/>
	  </inputs>
	  <interval>0.1</interval>
	</comp>

	<comp name=\"send%d\">
	  <op cmd=\"send\" host=\"localhost\" port=\"5000\"/>
	  <location>pc%d</location>
	  <inputs>
		<input name=\"dropFramesX%d\"/>
	  </inputs>
	  <interval>0.1</interval>
	</comp>
  </alt>";

enum util { ONE = 1, HALF = 2, TENTH = 3 };

static int make_spec(int source_num, int source_pc, int dest_pc,
		     int dest_num, enum util u, char *buf, int bufsz) {
  if (u == ONE) {
    return snprintf(buf,bufsz,util1_spec,source_num,source_pc,
		    source_num,source_pc,source_num, dest_num,
		    dest_pc, source_num);
  }
  else if (u == HALF) {
    return snprintf(buf,bufsz,util05_spec,source_num,source_pc,
		    source_num,source_pc,source_num, source_num,
		    source_num, dest_num, dest_pc, source_num);
  }
  else if (u == TENTH) {
    return snprintf(buf,bufsz,util01_spec,source_num,source_pc,
		    source_num,source_pc,source_num, source_num,
		    source_num, dest_num, dest_pc, source_num);
  }
  else {
    fprintf(stderr,"Failed---bad utility!\n");
    exit(1);
  }
} 

static int *gen_permutation(int num) {
  int *assigned;
  int available;
  int i, idx, tmp;

  assigned = (int *)malloc(num * sizeof (*assigned));

retry:
  for (i=0; i<num; i++) assigned[i] = i;
  if (num == 1)
    return assigned; 

  for (i=0; i<num; i++) {

    /* find an open slot */
    do {
      idx = rand() % num;
    } while (idx == i);

    /* assign it */
    tmp = assigned[idx];
    assigned[idx] = assigned[i];
    assigned[i] = tmp;
  }

/*    for (i=0;i<num;i++) */
/*      if (assigned[i] == i) */
/*        goto retry; */

  return assigned;
}

int main(int argc, char *argv[]) {
  int num_users;
  int num_sources;
  int num_nodes;
  char *outprefix;
  int i, j;
  struct timeval tm;
  int *source_pcs;

  if (argc != 5) {
    fprintf(stderr,"usage: %s <num users> <num sources> <num nodes> <outprefix>\n",argv[0]);
    exit(1);
  }
  num_users = atoi(argv[1]);
  num_sources = atoi(argv[2]);
  num_nodes = atoi(argv[3]);
  outprefix = argv[4];

  if (num_users <= 0 || num_sources <= 0 || num_nodes <= 0) {
    fprintf(stderr,"input #'s must be > 0\n");
    exit(1);
  }
  else if (num_users + num_sources > num_nodes) {
    fprintf(stderr,"num_users + num_sources != num_nodes\n");
    exit(1);
  }
  else if (num_users < num_sources) {
    fprintf(stderr,"num_users < num_sources!\n");
    exit(1);
  }    

  gettimeofday(&tm,NULL);
  srand(tm.tv_sec);

  source_pcs = gen_permutation(num_sources);

  for (i=0; i<num_users; i++) {
    char buf[20000];
    char *b;
    char filename[1000];
    FILE *outfp;
    int bufofs;
    int source_pc;
    int source_num;
    int bytes;

    snprintf(filename,sizeof(filename),"%s%d",outprefix,i+1);
    outfp = fopen(filename,"w");
    if (outfp == NULL) {
      fprintf(stderr,"Could not open file %s for writing\n",filename);
      exit(1);
    }
    
    source_num = (i % num_sources) + 1;
    source_pc = source_pcs[source_num-1] + 1;
#define SPEC "<spec>"
    strcpy(buf,SPEC);
    bufofs = strlen(SPEC);
    b = buf + bufofs;

    for (j = 1; j<=3; j++) {
      bytes = make_spec(source_num, source_pc, num_users + i + 1,
			i + 1, j, b, sizeof(buf) - bufofs);
      if (bytes == -1) {
	fprintf(stderr,"buf too small!\n");
	return -1;
      }
      b += bytes;
      bufofs += bytes;
    }

    strcat(buf,"\n</spec>\n");
    bytes = strlen(buf);

    fprintf(outfp,"%s",buf);
    fprintf(stderr,"%s",buf);

    fclose(outfp);
  }
  return 0;
}
