/* This file is part of the MediaNet Project.
   Copyright (C) 2002-2004 Michael Hicks, Robbert van Renesse

   MediaNet is free software; you can redistribute it and/or it
   under the terms of the GNU Lesser General Public License as
   published by the Free Software Foundation; either version 2.1 of
   the License, or (at your option) any later version.

   MediaNet is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with this library; see the file COPYING.LIB.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place, Suite
   330, Boston, MA 02111-1307 USA. */

#ifndef _GRAPH_H_
#define _GRAPH_H_

#include "oslib.h"

typedef struct graph *graph;

extern graph new_graph(int nnodes, char *name);
extern void free_graph(graph g);
extern void add_edge(graph g, int from, int to);
extern void add_node(graph g, char *name, char *location, int id);

extern void get_connected_comps(graph g, int **comps, int *num);

extern void print_adj_graph(graph g, struct print_channel *pc);
extern void print_dot_graph(graph g, struct print_channel *pc);

#endif
