/* This file is part of the MediaNet Project.
   Copyright (C) 2002-2004 Michael Hicks, Robbert van Renesse

   MediaNet is free software; you can redistribute it and/or it
   under the terms of the GNU Lesser General Public License as
   published by the Free Software Foundation; either version 2.1 of
   the License, or (at your option) any later version.

   MediaNet is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with this library; see the file COPYING.LIB.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place, Suite
   330, Boston, MA 02111-1307 USA. */

#include <stdlib.h>
#include <unistd.h>
#include <stdio.h>
#include <signal.h>
#include "oslib.h"
#include "mmsched.h"

extern void mmsched_init(int);
extern void http_done();
extern void schedsvr_done();

/* for parsing network configurations */
extern FILE *yyin;
extern int yyparse();
#ifdef YYDEBUG
extern int yydebug;
#endif

static void log_output(void *env, char *s){
	FILE *out = env;

	if (s != 0) {
		fprintf(out, "%s\n", s);
		fflush(out);
	}
}

int main(int argc, char **argv){
	struct ev_channel *schedsvr;
	void http_init(void), schedsvr_init(void);
	struct ev_channel *schedsvr_create(char *db);
	struct log_sub *log;
	char *db = "users.db";
	int config = 3;
	char *configFile = "";
	char *progName = argv[0];
	char ch;

#ifdef WIN32
	WSADATA wsaData;

	(void) WSAStartup(MAKEWORD(2, 0), &wsaData);
#endif

#ifdef SIGPIPE
	signal(SIGPIPE, SIG_IGN);
#endif
#ifdef SIGHUP
	signal(SIGHUP, SIG_IGN);
#endif

	/* Create a web server activity.
	 *
	 * Usage:  schedsvr [-p port] [-u db] [-c config] [-e]
	 */
	while ((ch = getopt(argc, argv, "p:u:f:h:c:e")) != EOF) 
	  switch (ch) {
	  case 'p':
	    parameters.schedsvr_port = atoi(optarg);
	    break;
	  case 'u':
	    db = optarg;
	    break;
	  case 'c':
	    config = atoi(optarg);
	    break;
	  case 'f':
	    configFile = optarg;
	    break;
	  case 'h':
	    parameters.schedsvr_host = optarg;
	    break;
	  case 'e':
	    parameters.emulab_link = 1;
	    break;
	  default:
	    fprintf(stderr, 
		    "usage: %s [-p port] [-h hostname] [-c config] [-f BRITE.config.file] [-u user db] [-e]\n", 
		    progName);
	    fprintf(stderr,"  -p port	HTTP port for config specs (def=%d)\n",
		    parameters.schedsvr_port);
	    fprintf(stderr,"  -h host	address to send reports to (def=%s)\n",
		    parameters.schedsvr_host);
	    fprintf(stderr,"  -u db	name of user database (def=%s)\n",db);
	    fprintf(stderr,"  -c config	network configuration number (def=%d)\n",config);
	    fprintf(stderr,"  -f BRITE network description file (def=%s)\n",configFile);
	    fprintf(stderr,"  -e treat links as addresses and send to them\n");
	    return 1;
	  }

	setbuf(stdout, 0);
	tst_init();
	log = log_subscribe(100, log_output, stderr);
	act_init();
	http_init();

	/* user-specified configuration by file */
	if (configFile[0] != '\0') {
	  yyin = fopen(configFile,"r");
	  if (yyin == NULL) {
	    fprintf(stderr,"Could not open file %s for reading\n",configFile);
	    exit(1);
	  }
#ifdef YYDEBUG
	  yydebug = 1;
#endif
	  if (yyparse()) {
	    fprintf(stderr,"Parsing failed!\n");
	    exit(1);
	  }
	  mmsched_init(-1);
	}
	/* pre-defined configuration */
	else
	  mmsched_init(config);

	schedsvr_init();

	schedsvr = schedsvr_create(db);

	/* Create a TCP server activity, and send its notifications to the web server.
	 */
	tcp_server_create(parameters.schedsvr_port, schedsvr);

	/* Main loop.
	 */
	while (run_block())
		;

	act_done();
	http_done();
	schedsvr_done();
	log_unsubscribe(log);
	Mem_Done();
	return 0;
}
