/* This file is part of the MediaNet Project.
   Copyright (C) 2002-2004 Michael Hicks, Robbert van Renesse

   MediaNet is free software; you can redistribute it and/or it
   under the terms of the GNU Lesser General Public License as
   published by the Free Software Foundation; either version 2.1 of
   the License, or (at your option) any later version.

   MediaNet is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with this library; see the file COPYING.LIB.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place, Suite
   330, Boston, MA 02111-1307 USA. */

#ifndef __TIMER_H__
#define __TIMER_H__

#define NO_TIMERS

#ifndef NO_TIMERS

#include <sys/time.h>

struct __timer {
  char *name;
  struct timeval total;
  struct timeval start;
  struct timeval end;
};

#define NEW_TIMER(n,t) struct __timer t = { n, {0,0}, {0,0}, {0,0}}
#define START_TIME(t) gettimeofday(&t.start,NULL)
#define END_TIME(t) {					\
  gettimeofday(&t.end,NULL);				\
  t.start.tv_sec = t.end.tv_sec - t.start.tv_sec;	\
  t.start.tv_usec = t.end.tv_usec - t.start.tv_usec;	\
  if (t.start.tv_usec < 0) {				\
    t.start.tv_usec += 1000000;				\
    t.start.tv_sec--;					\
  }						\
  t.total.tv_sec += t.start.tv_sec;		\
  t.total.tv_usec += t.start.tv_usec;		\
  if (t.total.tv_usec >= 1000000) {		\
    t.total.tv_usec -= 1000000;			\
    ++t.total.tv_sec;				\
  }						\
}
#define PRINT_TIME(t) printf("Timer %s: %d.%06d secs (total=%d.%06d)\n", t.name, (int)t.start.tv_sec, (int)t.start.tv_usec, (int)t.total.tv_sec, (int)t.total.tv_usec)

#else

#define NEW_TIMER(n,t)
#define START_TIME(t)
#define END_TIME(t)
#define PRINT_TIME(t)

#endif
#endif
