#include <sys/types.h>
#include <net/ethernet.h>

#include <map>

#include "common.h"
#include "Anon.h"
#include "DNS.h"
#include "IP.h"
#include "Ethernet.h"

namespace tcpmkpub {

	// mappings from pre-anon label location to post anon
	static map<uint16_t,uint16_t> post_anon_label_offset;
	static uint16_t question_count, answer_count, rr_count, ar_count;
	static uint16_t rr_data_type;
	static uint16_t offset_out_before_dns_hdr = 0;
	static uint16_t offset_in_before_dns_hdr = 0;

	DATA_PROCESSOR(anonymize_dns_pkt)
	{
		// Reset count variables
		question_count = 0;
		answer_count = 0;
		rr_count = 0;
		ar_count = 0;
		rr_data_type = 0;
		post_anon_label_offset.clear();
		offset_out_before_dns_hdr = offset_out;
		offset_in_before_dns_hdr = offset_in;

#	include "field.macros"
#	include "policy/dns.anon"
	}

// DNS Label anonymizer
HashKey dnslabelkey;

void init_dns_label_anonymization(HashKey key)
	{
		memcpy(dnslabelkey, key, sizeof(HashKey));
	}

	int encode_base16(u_char* in, int in_length, u_char* out)
	{
		char* hex_chars = "0123456789ABCDEF";
		int out_length = 0;
		for (int i=0; i < 2*in_length; i++)
		{
			out[out_length++]	= hex_chars[(in[i] >> (i%2)*4) & 0xF];
		}
		return out_length;
	}

	int anonymize_dns_label(u_char* label_in, int label_len, u_char* label_out)
	{
		HashDigest digest;
		hmac_md5(HASH_TYPE_RPERM, dnslabelkey, label_len,
			label_in, digest);
				
		u_char enc_len = 0;
		enc_len = encode_base16((u_char*)digest, sizeof(digest), label_out+1);

		label_out[0] = enc_len/2; 
		return enc_len/2 + 1;
	}

	DATA_PROCESSOR(anonymize_dns_name)
	{
		if (len == VARLEN)
			len = caplen - offset_in;

		if (len > 0)
		{
			int name_idx = offset_in;
			u_char label_len = start[name_idx];
			u_char label_input[65];

				while (label_len != 0)
				{
					// label is a pointer
					if ((label_len >> 6) == 0x3)
					{
						uint16_t name_pointer = *((uint16_t*)(start + name_idx));
						uint16_t idx = ntohs(name_pointer) & 0x3FFF; 
						idx = post_anon_label_offset[idx];
						uint16_t name_pointer_new = idx | 0xC000;
						name_pointer_new = htons(name_pointer_new);
						pkt_out->dump((u_char*)&name_pointer_new, 2, offset_out);
						offset_out += 2;
						if (offset_in + 2 >= caplen)
						{
							Alert("incomplete dns name");
							return;
						}
						offset_in += 2;
						// Label is a pointer, no furthern name anonymization is needed
						return;
					}

					else 
					{
						name_idx++;
						for (int i = 0; i < label_len; i++)
						{
							int label_idx = name_idx + i;
							if (label_idx >= caplen && pkt_in->truncated())
							{
								Alert("incomplete dns name");
								return;
							}
							label_input[i] = start[label_idx];
						}

						u_char label_out[65];
						int label_out_len = anonymize_dns_label(label_input, label_len, label_out);

						// Change the UDP/IP/802.11 Packet length
						pkt_out->Increase_Size_Fields((label_out_len-1) - label_len);

						pkt_out->dump(label_out, label_out_len, offset_out);

						// remember where the label started in the pre-anon packet
						post_anon_label_offset[offset_in-offset_in_before_dns_hdr] 
							= offset_out-offset_out_before_dns_hdr; 

						offset_out += label_out_len;
						name_idx += label_len;
						if (offset_in + label_len + 1 >= caplen)
						{
							Alert("incomplete dns name");
							return;
						}
						offset_in += label_len + 1;
						label_len = start[name_idx];
				}
			}
			pkt_out->dump((u_char)'\0', 1, offset_out);
			offset_out++;
			if (offset_in + 1 >= caplen)
			{
				Alert("incomplete dns name");
				return;
			}
			offset_in++;
		}
	}


	DATA_PROCESSOR(remember_dns_question_count)
	{
		question_count = ntohs(*((uint16_t*)(start + offset_in)));
		COPY_IT;	
	}

	DATA_PROCESSOR(remember_dns_answer_count)
	{
		answer_count = ntohs(*((uint16_t*)(start + offset_in)));
		COPY_IT;	
	}

	DATA_PROCESSOR(remember_dns_rr_count)
	{
		rr_count = ntohs(*((uint16_t*)(start + offset_in)));
		COPY_IT;	
	}

	DATA_PROCESSOR(remember_dns_ar_count)
	{
		ar_count = ntohs(*((uint16_t*)(start + offset_in)));
		COPY_IT;	
	}

	DATA_PROCESSOR(remember_dns_rr_data_type)
	{
		rr_data_type = ntohs(*((uint16_t*)(start + offset_in)));
		COPY_IT;	
	}

	DATA_PROCESSOR(anonymize_dns_data)
	{
		// Anonymize questions
		for (int i = 0; i < question_count; i++)
		{
#			include "field.macros"
#			include "policy/dns-question.anon"
		}
		// Anonymize answers
		for (int i = 0; i < answer_count; i++)
		{
#			include "field.macros"
#			include "policy/dns-rr.anon"
		}
		// Anonymize RRs
		for (int i = 0; i < rr_count; i++)
		{
#			include "field.macros"
#			include "policy/dns-rr.anon"
		}
		// Anonymize ARs
		for (int i = 0; i < ar_count; i++)
		{
#			include "field.macros"
#			include "policy/dns-rr.anon"
		}	
	}


	DATA_PROCESSOR(anonymize_dns_rr_data)
	{
		if ( len == VARLEN )
			len = caplen - offset_in;
		switch (rr_data_type)
		{
#			include "case.macros"
#			include "policy/dns-rr-data.anon"
		}
	}

}  // namespace tcpmkpub
