#ifndef etheraddr_h
#define etheraddr_h

#include "RPerm.h"
#include "DataProcessor.h"
#include "Scanner.h"
#include "Anon.h"

namespace tcpmkpub
{
	struct Mac
	{
		u_char mac[6];
		ScannerID scanner;

		Mac()			
			{ 
			memset(mac, 0, sizeof(mac)); 
			scanner = NO_SCANNER;
			}

		Mac(const u_char m[6], ScannerID s)	
			{ 
			memcpy(mac, m, sizeof(mac)); 
			scanner = s;
			}

		Mac(const Mac &x) 	
			{ 
			memcpy(mac, x.mac, sizeof(mac)); 
			scanner = x.scanner;
			}

		uint32_t vid() const 
			{
			return (mac[0] << 16) | (mac[1] << 8) | mac[2];
			}

		uint32_t hid() const 
			{
			return (mac[3] << 16) | (mac[4] << 8) | mac[5];
			}

		Mac& operator=(const Mac &x)
			{ 
			memcpy(mac, x.mac, sizeof(mac)); 
			scanner = x.scanner;
			return *this;
			}

		bool operator==(const Mac &x) const
			{ 
			return memcmp(mac, x.mac, sizeof(mac)) == 0 &&
				scanner == x.scanner; 
			}

		bool operator<(const Mac &x) const
			{
			if ( scanner != x.scanner )
				return scanner < x.scanner;
			for ( int i = 0; i < (int) sizeof(mac); ++i )
				if ( mac[i] != x.mac[i] )
					return mac[i] < x.mac[i];
			return false;
			}

	void from_string(const char* mac_in) 
			{
			sscanf(mac_in, "%02x:%02x:%02x:%02x:%02x:%02x", 
				(int*)&mac[0], (int*)&mac[1], (int*)&mac[2],
				(int*)&mac[3], (int*)&mac[4], (int*)&mac[5]);
			}

		string to_string() const
			{
			static char buf[32];
			snprintf(buf, sizeof(buf), "%02x:%02x:%02x:%02x:%02x:%02x (%s)", 
				mac[0], mac[1], mac[2], mac[3], mac[4], mac[5],
				scanner_to_string(scanner).c_str()); 
			return string(buf);
			}

		string to_string_noscan() const
			{
			static char buf[32];
			snprintf(buf, sizeof(buf), "%02x:%02x:%02x:%02x:%02x:%02x", 
				mac[0], mac[1], mac[2], mac[3], mac[4], mac[5]);
			return string(buf);
			}

	};

	class AMac
	{
	public:
		AMac(HashKey key);
		~AMac();
		void anonymize(const Mac& input, Mac& output);

	protected:
		void do_anonymize(const Mac& input, Mac& output);
		void map_mac_bits(const u_char input[3], u_char output[3],
			size_t seed_size, const u_char *seed, 
			bool keep_all_zero, 
			bool preserve_multicast_bit);
		HashKey key;
		map<Mac, Mac> mac_map;
	};

}

#endif /* etheraddr_h */
