#include <sys/types.h>
#include <net/ethernet.h>

#include "Anon.h"
#include "LLC.h"
#include "SNAP.h"
#include "Ethernet.h"
#include "IP.h"
#include "ARP.h"

namespace tcpmkpub {

DATA_PROCESSOR(anonymize_llc_pkt)
	{
#	include "field.macros"
#	include "policy/llc.anon"
	}

DATA_PROCESSOR(other_llc_pkt_alert_and_skip)
	{
	if ( FLAGS_alert_on_non_IP_pkts )
		Alert("non-SNAP packet %d", pkt_in->LLCHeader()->dsap);
	SKIP_IT;
	}

DATA_PROCESSOR(anonymize_llc_data)
	{
	if ( len == VARLEN )
		len = caplen - offset_in;

	const struct llc_header* llc = pkt_in->LLCHeader();
	if (llc->dsap != llc->ssap)
	{
		if ( FLAGS_alert_on_non_IP_pkts )
			Alert("LLC saps are not the same %d, %d", llc->dsap, llc->ssap);
		SKIP_IT;
	}

	switch ( llc->dsap )
		{
#		include "case.macros"
#		include "policy/llc-data.anon"
		}
	}

}  // namespace tcpmkpub
