#include <sys/types.h>
#include <net/ethernet.h>

#include "Anon.h"
#include "SNAP.h"
#include "Ethernet.h"
#include "IP.h"
#include "ARP.h"

namespace tcpmkpub {

DATA_PROCESSOR(anonymize_snap_pkt)
	{
#	include "field.macros"
#	include "policy/snap.anon"
	}

DATA_PROCESSOR(other_snap_pkt_alert_and_skip)
	{
//	if ( FLAGS_alert_on_non_IP_pkts )
		Alert("non-IP packet %x", pkt_in->NetworkType());
		SKIP_IT;
	}

DATA_PROCESSOR(anonymize_snap_data)
	{
	if ( len == VARLEN )
		len = caplen - offset_in;

	switch ( pkt_in->NetworkType() )
		{
#		include "case.macros"
#		include "policy/snap-data.anon"
		}
	}

}  // namespace tcpmkpub
