#include <sys/types.h>
#include <net/ethernet.h>

#include "Anon.h"
#include "VLAN.h"
#include "Ethernet.h"
#include "IP.h"
#include "ARP.h"

namespace tcpmkpub {

DATA_PROCESSOR(anonymize_vlan_pkt)
	{

	pkt_in->SetLinkType(LINKTYPE_ETHERNET_VLAN);
	pkt_out->SetLinkType(LINKTYPE_ETHERNET_VLAN);

#	include "field.macros"
#	include "policy/vlan.anon"
	}

DATA_PROCESSOR(anonymize_vlan_data)
	{
	if ( len == VARLEN )
		len = caplen - offset_in;

	switch ( pkt_in->VLANNetworkType() )
		{
#		include "case.macros"
#		include "policy/ether-data.anon"
		}
	}

}  // namespace tcpmkpub
