#include <sys/types.h>
#include <net/ethernet.h>

#include "Anon.h"
#include "WiFi.h"
#include "LLC.h"
#include "Ethernet.h"

namespace tcpmkpub {

// Note: For packets with payload curtailed, we cannot keep the
// ethernet checksums. Then shall we really try to keep ethernet
// checksum for *some* packets? Or leave them out all together?
// Check policy/ether.anon.
/*DATA_PROCESSOR(recompute_ethernet_cheksum)
	{
	if ( offset_in == offset_out )
		ZERO_IT;
	else
		SKIP_IT;
	}*/

DATA_PROCESSOR(anonymize_wifi_pkt)
	{
	pkt_in->SetLinkHeader(offset_in);
	pkt_out->SetLinkHeader(offset_out);

	pkt_in->SetLinkType(LINKTYPE_WIFI);
	pkt_out->SetLinkType(LINKTYPE_WIFI);

#	include "field.macros"
#	include "policy/wifi.anon"
	}

DATA_PROCESSOR(anonymize_wifi_data)
{
	if ( len == VARLEN )
		len = caplen - offset_in;

		// if this is a fragmented packet
		if (pkt_in->WiFiFragmented() || pkt_in->WiFiFragment() > 0)
		{
			Alert("fragmented\n");
			SKIP_IT;
		}
		else
		{
			switch ( pkt_in->WiFiType() )
				{
#		include "case.macros"
#		include "policy/wifi-data.anon"
				}
		}
}

DATA_PROCESSOR(anonymize_wifi_type_data)
{
	if ( len == VARLEN )
		len = caplen - offset_in;

	// Only continue to llc if the packet has data in it
	int subtype = pkt_in->WiFiSubType();
	if (subtype >= 0 && subtype < 4)
	{
#		include "field.macros"
#		include "policy/llc.anon"
	}
	else 
	{
		COPY_IT;
	}
}

DATA_PROCESSOR(keep_wifi_data)
{
	if ( len == VARLEN )
		len = caplen - offset_in;
	COPY_IT;
}


DATA_PROCESSOR(other_wifi_pkt_alert_and_skip)
	{
	if ( FLAGS_alert_on_non_IP_pkts )
		Alert("non-802.11: Data/Manegment/Control packet %d", pkt_in->WiFiType());
	SKIP_IT;
	}

}  // namespace tcpmkpub
