#include <stdio.h>
#include <iostream>
#include <sys/types.h>

#include "TCPMkPub.h"
#include "EtherAddr.h"

#include "Hash.h"

int main(int argc, char** argv) 
{
	if (argc != 3)
	{
		printf("%s <tcpmkpub key> <mac address>\n", argv[0]);
		exit(0);
	}

	const char* keyinfo = argv[1];

	tcpmkpub::note_off = true;

	// Generate key from key information given on the command line
	tcpmkpub::HashKey tcpmkpub_key;
	tcpmkpub::generate_key(keyinfo, tcpmkpub_key);

	tcpmkpub::Mac input, output;
	tcpmkpub::AMac *amac = 0;

	amac = new tcpmkpub::AMac(tcpmkpub_key);

	input.from_string(argv[2]);
	amac->anonymize(input, output);

	cout << output.to_string_noscan() << endl;
}
