function [L,P,A] = lpa(b,c_el,c_ea,c_pa,mu_l,mu_a,L0,P0,A0,ncycles)

% [L,P,A] = lpa(b,c_el,c_ea,c_pa,mu_l,mu_a,L0,P0,A0,ncycles)
%
% Beetles, Cannibalism, and Chaos
% Computes the results of applying the model of 
%    Brian Dennis, Robert A. Desharnais, J. M. Cushing, and R. F. Constantino,
%    ``Nonlinear demographic dynamics: mathematical models, statistical
%    methods, and biological experiments,"
%    Ecological Monographs 63, No. 3, 1995, 261-281.
% to initial data L0, P0, A0, for ncycles cycles.
%
% This model aims to predict the number of larvae, pupae, and adult
% Tribolium castaneum (red beetles) given parameters for cannibalism
% (c_el, c_ea, and c_pa), parameters for death from other causes
% (mu_l and mu_a), and the number of larvae recruited by each adult (b).
%
% lpa.m Dianne O'Leary 12/2006

L = L0;
P = P0;
A = A0;

for j=1:ncycles-1,
    L(j+1) = b * A(j) * exp(-c_ea*A(j) - c_el*L(j));
    P(j+1) = L(j) * (1 - mu_l);
    A(j+1) = P(j) * exp(-c_pa * A(j)) + A(j) * (1 - mu_a);
end

