global mu_l mu_a c_ea c_el c_pa b mydatafit myDays

% Beetles, Cannibalism, and Chaos
% Solution to Problem 1
% Dianne O'Leary 12/2006
% Reproduce Figure 5 in Dennis, Desharnais, Cushing, Costantino
% by running the LPA model (in function lpa.m) with the following 
% parameter values:

b = 11.6772;
Mua =  [.1; .6; .9];
mu_l = .5129;

c_el = 0.0093;
c_ea = 0.0110;
c_pa = 0.0178;

% This loop creates the three plots.

ncycles = 50;

for mycase = 1:3,
   mu_a = Mua(mycase);
   L0 = 70;
   P0 = 30;
   A0 = 70;


   [L,P,A] = lpa(b,c_el,c_ea,c_pa,mu_l,mu_a,L0,P0,A0,ncycles);
   
   subplot(3,1,mycase)
   plot(0:ncycles-1, L, 'b:', 0:ncycles-1, P, 'g-', 0:ncycles-1, A, 'r--')
   xlabel('time (two-week periods)')
   legend('Larvae', 'Pupae', 'Adults')
   hold on

end

subplot(3,1,1)
title('Results of the LPA model with three different choices of \mu_a')
