%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%  Your Homework Assignment
%  Solving Sparse Linear Systems: Taking the Direct Approach
%
%  Solution to problem 4.
%  Solve the linear system Au=b where A is 
%  1.  an adaptive  finite element approximation to
%       -u_{xx} - u_{yy} = f(x,y)
%      in a circle with a slit cut from it
%      (generated by slit2.m)
%  or
%  2.  a uniform finite difference approximation to
%       - u_{xx} - u_{yy} -u_{zz} = f(x,y,z)
%      for (x,y,z) in (0,1) x (0,1) x (0,1),
%      with u = 0 on the boundary of the box.
%
%  Use varying meshes,  with h=1/(n+1), and solve using
%  the Cholesky algorithm using various reorderings of the matrix,
%  recording the resources consumed.
%
%  problem4.m Dianne O'Leary  06-2005
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

path(path,'/prost/oleary/cseproj/project15/meshpart')

disp('Generating some test problems')

[A1,b1,h1,A2,b2,h2] = slit2;

problems = ['Laplace equation on circle sector'
            'Laplace equation on circle sector'
            'Laplace equation on box,         '];
       
droptol = .05;

alg = ['                 Cholesky'
       'Cholesky, R-Cuthill-McKee'
       'Cholesky,  minimum degree'
       'Cholesky,  approx. mindeg'
       'Cholesky,  eigenpartition'];

for i=1:3,
  if (i==1)
    A = A1; b = b1; h = h1;
  elseif (i==2)
    A = A2; b = b2; h = h2;
  else
    clear A1 b1 h1 A2 b2 h2
    [A ,b ,h ] = laplace3d(25);
  end

  disp('  ')
  disp(sprintf('Solving %33s with n=%d ', ...
             problems(i,:),length(b)))

  [nz,ctime,rnorm] = runmethods(A,b);

  disp('        Algorithm               storage     time  residual_norm')
  for i=1:5,
    disp(sprintf('%25s      %8d   %5.2e   %5.2e', ...
            alg(i,:),nz(i),ctime(i),rnorm(i)))
  end
end
