
function dy = epi(t,y)

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%  function dy = epi(t,y)                                %
%  Solution to CSE Your Homework Assignment Project 6    %
%  More Models of Infection: It's Epidemic               %
%  epi.m Dianne P. O'Leary   11/03                       %
%                                                        %
%  This program evaluates dy/dt for Problem 5.           %
%  In the y vector, components i=1:N are equal to the    %
%  proportion of the population infected at the i-th     %
%  site, while components i=N+1:2N are the proportion    %
%  susceptible at site i-N.                              %
%                                                        %
%  For Problem 5b and c, we also track the vaccinated    %
%  proportion in components i=2N+1:3N.  This is activated%
%  by setting a nonzero vaccination rate  myvac.         %
%                                                        %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

global myn  myN  myrecov  mytrans  mymobil  myA myvac

infe = y(1:myN,:);
susc = y(myN+1:2*myN,:);

Ai = mymobil* (myA* infe).*susc;
mix = mytrans*(infe.*susc);
dv = myvac*(susc.*infe)./(infe+susc);

ds = - mix - Ai - dv;
di =   mix + Ai - infe/myrecov;

if (myvac==0)
  dy = [di;ds];
else
  dy = [di;ds;dv];
end

