

mysymb='.bogxr+c*mskdbvg^r<c>mpkhb.gorxc+m*ksbdg';
% 1 and 7 or 2 and 4
myproblem = 2;
nrefine = 4;
kappa = 0;
disp('Generate the problem.')
%generateA
mesh = generateproblem(myproblem,nrefine,kappa);
n = length(mesh(nrefine).b)
residnorm = norm(mesh(nrefine).b);
nsmooth = 3;
tol = 1.e-5*sqrt(n);

[mesh(1).L,mesh(1).U] = lu(mesh(1).A);

disp('Start the multigrid iteration.')
itn = 0;
disp(sprintf('Iteration %d, residual norm %e',itn,residnorm))
while(residnorm > tol)

% Walk from fine to coarse.

   for k=nrefine:-1:1,
    if (k < nrefine)
       mesh(k).u = zeros(size(mesh(k).b));
    end
    mesh(k).u = smooth(mesh(k).A,mesh(k).b,mesh(k).u,nsmooth);
    if (k > 1)
       mesh(k-1).b = mesh(k).Prolong' * (mesh(k).b - mesh(k).A * mesh(k).u);
    end
   end

% Walk from coarse to fine, using a direct method on the coarsest grid.

   for k=1:nrefine,

    if (k==1)
       mesh(k).u = mesh(1).U \ (mesh(1).L \ mesh(1).b);
    else
       mesh(k).u = smooth(mesh(k).A,mesh(k).b,mesh(k).u,nsmooth);
    end
    if (k < nrefine)
       mesh(k+1).u = mesh(k+1).u + mesh(k+1).Prolong * mesh(k).u;
    end
   end

   residnorm = norm(mesh(nrefine).A * mesh(nrefine).u - mesh(nrefine).b);
   itn = itn + 1;
   disp(sprintf('Iteration %d, residual norm %e',itn,residnorm))

end
