function [e,eratios] = test(kappa)
% Test the problem generation. 
% This uses function utrue.

nrefine = 6;
mesh = generateproblem(1,nrefine,kappa);

for i=1:nrefine,

    u = mesh(i).A \ mesh(i).b;
    p = mesh(i).p;

    utru = utrue(p(1:mesh(i).nip,:));
    e(i) = norm(u-utru)/mesh(i).nip;

    [i,e(i)]

end

eratios = e(1:nrefine-1)./e(2:nrefine)
