
function [xmin,fmin,nmin] = myfmin(myf,a,b,nsamp)

% function [xmin,fmin,nmin] = myfmin(myf,a,b,nsamp)
%
% This function minimizes the function myf (of a single variable)
% over the interval [a,b]
% using a set of random starting points sent to Matlab's fmincon.
%
%
% Inputs:
%   myf    a "handle" for a Matlab function
%   a      left  endpoint of the interval
%   b      right endpoint of the interval
%   nsamp  the number of random samples to generate
%
%  Outputs:
%    xmin  the computed minimizer
%    fmin  the computed minimum myf(xmin)
%    nmin  the number of calls made to fmincon
%
%  fminL  Dianne P. O'Leary 10/2006
%                           11/2008 update
%                           10/2009 update


% Initialize our best guess at the minimizer to be the left endpoint.

xmin = a;
fmin = feval(myf,a);  % 10/2009

% Initialize an array of Nsamp random starting points.

x0 =  a + (b-a)*rand(nsamp,1);


% Consider each of the starting points.

for i=1:nsamp,   % 11/2008

   x = x0(i);

   [xopt,fopt] = fmincon(myf,x,[],[],[],[],a,b);  % 10/2009

% See if xopt is the best point seen yet.

   if (fopt < fmin)
      xmin = xopt;
      fmin = fopt;
   end
end

nmin = nsamp;

[nmin, xmin, fmin]
