function [nunique,uniquetheta,uniquetop] = count(theta,todraw,probname)

% function [nunique,uniquetheta,uniquetop] = count(theta,todraw,probname)
% Input:
%   theta        the different solutions found
%   todraw       =1 if each truss is to be plotted
%   probname     used in figure title
%
% Output: 
%   nunique      the number of unique angle solutions
%   uniquetheta  the different solution angles
%   uniquetop    the 9 coordinates of the top, corresponding to the
%                   unique angles.
% Dianne P. O'Leary 08/2007

global myl_vert myl_bott myl_top

[n,ntheta] = size(theta);

nunique = 0;
unique = [];
twopi = 2*pi;

for j=1:ntheta,

   for k=1:3,

% Put all angles in the interval [0, 2pi].

      while (theta(k,j) < 0)
          theta(k,j) = theta(k,j) + twopi;
      end

      while (theta(k,j) > twopi)
          theta(k,j) = theta(k,j) - twopi;
      end
   end

% If this one is new, add it to the collection.

      [F,z,Tbott,Ttop] = trusscheck(theta(:,j),myl_vert,myl_bott,myl_top,0);
      if (z < 2)
         disp('Very bad error in count.m: bad truss.')
         %disp('Pausing.')
         %pause
      end
      Ttopstretch = reshape(Ttop',1,9);

      new = 1;
      for jj = 1:nunique,

         if (norm(Ttopstretch-uniquetop(jj,:)) < 1.e-3*norm(uniquetop(jj,:)))
             new = 0;
             break
         end
      end

      if new
         nunique = nunique + 1;
         uniquetheta(:,nunique) = theta(:,j);
         uniquetop(nunique,:) = Ttopstretch;
      end
end

% Sort the unique ones and plot if desired.

[asort,jsort] = sort(uniquetop(:,1));
uniquetop   = uniquetop(jsort,:);
uniquetheta = uniquetheta(:,jsort);
if todraw
   for j=1:nunique,
       figure
       drawtruss(Tbott,reshape(uniquetop(j,:),3,3))
       ss = sprintf('print -depsc %s%d.eps',probname,j);
       eval(ss)
   end
end
