function drawtruss(base,top)


% function drawtruss(base,top)
% Draws a Matlab figure containing a truss platform.
% Needs 6x3 coordinates of the 6 vertices of the truss.
% Input:
%       base:3x3, each row contains a vertex (blue)
%        top:3x3, each row contains a vertex (red)
% Dianne P. O'Leary 05/2008

l3 = 2.5     %line width

offset = .05*max(max(abs(top)));

hold off

plot3(base(1:2,1),base(1:2,2),base(1:2,3),'LineWidth',l3) %ab
hold on
plot3(base(2:3,1),base(2:3,2),base(2:3,3),'LineWidth',l3) %bc
plot3(base([1,3],1),base([1,3],2),base([1,3],3),'LineWidth',l3) %ac

txt = text;
set(txt,'position',base(1,:)+offset,'string',{'A_1'})
txt = text;
set(txt,'position',base(2,:)+offset,'string',{'B_1'})
txt = text;
set(txt,'position',base(3,:)-offset,'string',{'C_1'})

txt = text;
set(txt,'position',top(1,:)+offset,'string',{'A_2'})
txt = text;
set(txt,'position',top(2,:)+offset,'string',{'B_2'})
txt = text;
set(txt,'position',top(3,:)-offset,'string',{'C_2'})

plot3(top(1:2,1),top(1:2,2),top(1:2,3),'r','LineWidth',l3) %ab
hold on
plot3(top(2:3,1),top(2:3,2),top(2:3,3),'r','LineWidth',l3) %bc
plot3(top([1,3],1),top([1,3],2),top([1,3],3),'r','LineWidth',l3) %ac

aabar = [base(1,:);top(1,:)];
acbar = [base(1,:);top(3,:)];

l3 = .8*l3;

plot3(aabar(:,1),aabar(:,2),aabar(:,3),'k','LineWidth',l3);
plot3(acbar(:,1),acbar(:,2),acbar(:,3),'k','LineWidth',l3);

bbbar = [base(2,:);top(2,:)];
babar = [base(2,:);top(1,:)];

plot3(bbbar(:,1),bbbar(:,2),bbbar(:,3),'k','LineWidth',l3);
plot3(babar(:,1),babar(:,2),babar(:,3),'k','LineWidth',l3);

cbbar = [base(3,:);top(2,:)];
ccbar = [base(3,:);top(3,:)];

plot3(cbbar(:,1),cbbar(:,2),cbbar(:,3),'k','LineWidth',l3);
plot3(ccbar(:,1),ccbar(:,2),ccbar(:,3),'k','LineWidth',l3);

axis off

%view(0,90)
